/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class MessageCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;

    public MessageCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source2 = invocation.source();
        String[] args2 = (String[])invocation.arguments();
        if (!this.plugin.isPrivateMessagesModuleEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getModuleDisabledMessage()));
            return;
        }
        if (!(source2 instanceof Player)) {
            source2.sendMessage(MessageUtils.formatMessage("&cThis command can only be executed by a player."));
            return;
        }
        Player sender = (Player)source2;
        String sendPermission = this.plugin.getConfigManager().getPrivateMessagesSendPermission();
        if (!sendPermission.isEmpty() && !sender.hasPermission(sendPermission)) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        if (args2.length < 2) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorInvalidUsageMsg()));
            return;
        }
        String targetName = args2[0];
        Optional targetOptional = this.plugin.getServer().getPlayer(targetName);
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 1; i < args2.length; ++i) {
            messageBuilder.append(args2[i]).append(" ");
        }
        String message = messageBuilder.toString().trim();
        if (targetOptional.isPresent()) {
            Player target = (Player)targetOptional.get();
            this.plugin.getMessagingManager().sendMessage(sender, target, message);
        } else {
            boolean crossProxyAttempted = this.plugin.getMessagingManager().sendCrossProxyMessage(sender, targetName, message);
            if (!crossProxyAttempted) {
                sender.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorPlayerNotFound()));
            }
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        String[] args2 = (String[])invocation.arguments();
        if (args2.length == 1) {
            String partialName = args2[0];
            if (this.plugin.getCrossProxyMessagingManager() != null && this.plugin.getConfigManager().isPrivateMessagesRedisEnabled()) {
                List<String> completions = this.plugin.getCrossProxyMessagingManager().getFilteredPlayerNames(partialName);
                return CompletableFuture.completedFuture(completions);
            }
            List completions = this.plugin.getServer().getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(partialName.toLowerCase())).collect(Collectors.toList());
            return CompletableFuture.completedFuture(completions);
        }
        return CompletableFuture.completedFuture(new ArrayList());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        String sendPermission = this.plugin.getConfigManager().getPrivateMessagesSendPermission();
        return sendPermission.isEmpty() || invocation.source().hasPermission(sendPermission);
    }
}

