/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;

public class LockChatCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;

    public LockChatCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source2 = invocation.source();
        if (!this.plugin.getConfigManager().isLockChatEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlModuleDisabledMessage()));
            return;
        }
        String usePermission = this.plugin.getConfigManager().getLockChatUsePermission();
        if (source2 instanceof Player && !usePermission.isEmpty() && !source2.hasPermission(usePermission)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlNoPermissionMessage()));
            return;
        }
        boolean newLockState = this.plugin.getChatControlManager().toggleChatLock();
        String playerName = source2 instanceof Player ? ((Player)source2).getUsername() : "Console";
        String message = newLockState ? this.plugin.getConfigManager().getLockChatLockedMessage() : this.plugin.getConfigManager().getLockChatUnlockedMessage().replace("{player}", playerName);
        Component formattedMessage = MessageUtils.formatMessage(message);
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            player.sendMessage(formattedMessage);
        }
        this.plugin.getLogger().info("Chat " + (newLockState ? "locked" : "unlocked") + " by " + playerName);
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(new ArrayList());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        if (invocation.source() instanceof ConsoleCommandSource) {
            return true;
        }
        String usePermission = this.plugin.getConfigManager().getLockChatUsePermission();
        return usePermission.isEmpty() || invocation.source().hasPermission(usePermission);
    }
}

