/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class LobbyCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();

    public LobbyCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source2 = invocation.source();
        if (!this.plugin.isLobbyCommandModuleEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getModuleDisabledMessage()));
            return;
        }
        if (!(source2 instanceof Player)) {
            source2.sendMessage(MessageUtils.formatMessage("&cThis command can only be executed by a player."));
            return;
        }
        Player player = (Player)source2;
        String permission = this.plugin.getConfigManager().getLobbyUsePermission();
        if (!permission.isEmpty() && !player.hasPermission(permission)) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getLobbyNoPermissionMessage()));
            return;
        }
        if (!this.checkCooldown(player)) {
            return;
        }
        String targetServerName = this.plugin.getConfigManager().getLobbyTargetServer();
        RegisteredServer targetServer = this.plugin.getServer().getServer(targetServerName).orElse(null);
        if (targetServer == null) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getLobbyServerNotFoundMessage()));
            return;
        }
        if (player.getCurrentServer().isPresent() && ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName().equals(targetServerName)) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getLobbyAlreadyOnServerMessage()));
            return;
        }
        player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getLobbySuccessMessage()));
        player.createConnectionRequest(targetServer).fireAndForget();
        this.setCooldown(player);
    }

    private boolean checkCooldown(Player player) {
        long cooldownMillis;
        UUID playerId = player.getUniqueId();
        int cooldownSeconds = this.plugin.getConfigManager().getLobbyCooldown();
        if (cooldownSeconds <= 0) {
            return true;
        }
        String bypassPermission = this.plugin.getConfigManager().getLobbyCooldownBypassPermission();
        if (!bypassPermission.isEmpty() && player.hasPermission(bypassPermission)) {
            return true;
        }
        Long lastUsed = this.cooldowns.get(playerId);
        if (lastUsed == null) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        long timeDiff = currentTime - lastUsed;
        if (timeDiff < (cooldownMillis = (long)cooldownSeconds * 1000L)) {
            long remainingSeconds = (cooldownMillis - timeDiff) / 1000L + 1L;
            String message = this.plugin.getConfigManager().getLobbyCooldownMessage().replace("{time}", String.valueOf(remainingSeconds));
            player.sendMessage(MessageUtils.formatMessage(message));
            return false;
        }
        return true;
    }

    private void setCooldown(Player player) {
        int cooldownSeconds = this.plugin.getConfigManager().getLobbyCooldown();
        if (cooldownSeconds > 0) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(List.of());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        if (!(invocation.source() instanceof Player)) {
            return false;
        }
        String permission = this.plugin.getConfigManager().getLobbyUsePermission();
        if (permission.isEmpty()) {
            return true;
        }
        return invocation.source().hasPermission(permission);
    }
}

