/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class IgnoreCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;
    private static final String PERMISSION = "bmsproxycore.message.ignore";

    public IgnoreCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String subCommand;
        CommandSource source2 = invocation.source();
        String[] args2 = (String[])invocation.arguments();
        if (!(source2 instanceof Player)) {
            source2.sendMessage(MessageUtils.formatMessage("&cThis command can only be executed by a player."));
            return;
        }
        Player player = (Player)source2;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        if (args2.length == 0) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorInvalidUsageIgnore()));
            return;
        }
        switch (subCommand = args2[0].toLowerCase()) {
            case "add": {
                if (args2.length < 2) {
                    player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorInvalidUsageIgnore()));
                    return;
                }
                this.handleAddIgnore(player, args2[1]);
                break;
            }
            case "remove": {
                if (args2.length < 2) {
                    player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorInvalidUsageIgnore()));
                    return;
                }
                this.handleRemoveIgnore(player, args2[1]);
                break;
            }
            case "list": {
                this.handleListIgnore(player);
                break;
            }
            default: {
                player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorInvalidUsageIgnore()));
            }
        }
    }

    private void handleAddIgnore(Player player, String targetName) {
        Optional targetOptional = this.plugin.getServer().getPlayer(targetName);
        if (targetOptional.isEmpty()) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorPlayerNotFound()));
            return;
        }
        Player target = (Player)targetOptional.get();
        if (player.getUniqueId().equals(target.getUniqueId())) {
            player.sendMessage(MessageUtils.formatMessage("&cYou cannot ignore yourself."));
            return;
        }
        boolean added = this.plugin.getMessagingManager().addIgnoredPlayer(player.getUniqueId(), target.getUniqueId());
        if (added) {
            String message = this.plugin.getConfigManager().getMessagingIgnoreAdded().replace("{player}", target.getUsername());
            player.sendMessage(MessageUtils.formatMessage(message));
        } else {
            String message = this.plugin.getConfigManager().getMessagingErrorAlreadyIgnoring().replace("{player}", target.getUsername());
            player.sendMessage(MessageUtils.formatMessage(message));
        }
    }

    private void handleRemoveIgnore(Player player, String targetName) {
        Optional targetOptional = this.plugin.getServer().getPlayer(targetName);
        if (targetOptional.isEmpty()) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingErrorPlayerNotFound()));
            return;
        }
        Player target = (Player)targetOptional.get();
        boolean removed = this.plugin.getMessagingManager().removeIgnoredPlayer(player.getUniqueId(), target.getUniqueId());
        if (removed) {
            String message = this.plugin.getConfigManager().getMessagingIgnoreRemoved().replace("{player}", target.getUsername());
            player.sendMessage(MessageUtils.formatMessage(message));
        } else {
            String message = this.plugin.getConfigManager().getMessagingErrorNotIgnoring().replace("{player}", target.getUsername());
            player.sendMessage(MessageUtils.formatMessage(message));
        }
    }

    private void handleListIgnore(Player player) {
        Set<UUID> ignoredPlayers = this.plugin.getMessagingManager().getIgnoredPlayers(player.getUniqueId());
        if (ignoredPlayers.isEmpty()) {
            player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingIgnoreListEmpty()));
            return;
        }
        player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getMessagingIgnoreListHeader()));
        for (UUID ignoredUUID : ignoredPlayers) {
            Optional ignoredPlayer = this.plugin.getServer().getPlayer(ignoredUUID);
            String name = ignoredPlayer.map(Player::getUsername).orElse("Unknown");
            String entry = this.plugin.getConfigManager().getMessagingIgnoreListEntry().replace("{player}", name);
            player.sendMessage(MessageUtils.formatMessage(entry));
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        String[] args2 = (String[])invocation.arguments();
        if (args2.length == 1) {
            List<String> completions = Arrays.asList("add", "remove", "list");
            String current = args2[0].toLowerCase();
            return CompletableFuture.completedFuture(completions.stream().filter(c -> c.startsWith(current)).collect(Collectors.toList()));
        }
        if (args2.length == 2 && (args2[0].equalsIgnoreCase("add") || args2[0].equalsIgnoreCase("remove"))) {
            String partialName = args2[1].toLowerCase();
            List completions = this.plugin.getServer().getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(partialName)).collect(Collectors.toList());
            return CompletableFuture.completedFuture(completions);
        }
        return CompletableFuture.completedFuture(new ArrayList());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission(PERMISSION);
    }
}

