/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

public class ClearChatCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;

    public ClearChatCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source2 = invocation.source();
        if (!this.plugin.getConfigManager().isClearChatEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlModuleDisabledMessage()));
            return;
        }
        String usePermission = this.plugin.getConfigManager().getClearChatUsePermission();
        if (source2 instanceof Player && !usePermission.isEmpty() && !source2.hasPermission(usePermission)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlNoPermissionMessage()));
            return;
        }
        int emptyMessages = this.plugin.getConfigManager().getClearChatEmptyMessages();
        TextComponent emptyMessage = Component.empty();
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            for (int i = 0; i < emptyMessages; ++i) {
                player.sendMessage((Component)emptyMessage);
            }
        }
        String playerName = source2 instanceof Player ? ((Player)source2).getUsername() : "Console";
        String completionMessage = this.plugin.getConfigManager().getClearChatCompletionMessage().replace("{player}", playerName);
        Component formattedCompletionMessage = MessageUtils.formatMessage(completionMessage);
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            player.sendMessage(formattedCompletionMessage);
        }
        this.plugin.getLogger().info("Chat cleared by " + playerName);
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(new ArrayList());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        if (invocation.source() instanceof ConsoleCommandSource) {
            return true;
        }
        String usePermission = this.plugin.getConfigManager().getClearChatUsePermission();
        return usePermission.isEmpty() || invocation.source().hasPermission(usePermission);
    }
}

