/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ChatFilterCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;

    public ChatFilterCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String subCommand;
        CommandSource source2 = invocation.source();
        String[] args2 = (String[])invocation.arguments();
        if (!this.plugin.isChatControlModuleEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlModuleDisabledMessage()));
            return;
        }
        if (!this.plugin.getConfigManager().isChatFilterEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlModuleDisabledMessage()));
            return;
        }
        String managePermission = this.plugin.getConfigManager().getChatFilterManagePermission();
        if (source2 instanceof Player && !managePermission.isEmpty() && !source2.hasPermission(managePermission)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlNoPermissionMessage()));
            return;
        }
        if (args2.length == 0) {
            this.sendUsage(source2);
            return;
        }
        switch (subCommand = args2[0].toLowerCase()) {
            case "add": {
                this.handleAddCommand(source2, args2);
                break;
            }
            case "remove": 
            case "delete": {
                this.handleRemoveCommand(source2, args2);
                break;
            }
            case "list": {
                this.handleListCommand(source2);
                break;
            }
            case "reload": {
                this.handleReloadCommand(source2);
                break;
            }
            case "clear": {
                this.handleClearCommand(source2);
                break;
            }
            default: {
                this.sendUsage(source2);
            }
        }
    }

    private void handleAddCommand(CommandSource source2, String[] args2) {
        if (args2.length < 2) {
            source2.sendMessage(MessageUtils.formatMessage("&cUsage: /chatfilter add <regex_pattern>"));
            return;
        }
        if (this.plugin.getChatControlManager().isAtMaxFilterRules()) {
            int maxRules = this.plugin.getConfigManager().getChatControlMaxFilterRules();
            source2.sendMessage(MessageUtils.formatMessage("&cMaximum number of filter rules reached (" + maxRules + ")."));
            return;
        }
        StringBuilder patternBuilder = new StringBuilder();
        for (int i = 1; i < args2.length; ++i) {
            if (i > 1) {
                patternBuilder.append(" ");
            }
            patternBuilder.append(args2[i]);
        }
        String pattern = patternBuilder.toString();
        if (this.plugin.getChatControlManager().addFilterRule(pattern, true)) {
            String message = this.plugin.getConfigManager().getChatFilterRuleAddedMessage().replace("{rule}", pattern);
            source2.sendMessage(MessageUtils.formatMessage(message));
        } else if (this.plugin.getChatControlManager().getFilterRules().contains(pattern)) {
            String message = this.plugin.getConfigManager().getChatFilterRuleAlreadyExistsMessage().replace("{rule}", pattern);
            source2.sendMessage(MessageUtils.formatMessage(message));
        } else {
            String message = this.plugin.getConfigManager().getChatFilterInvalidRegexMessage().replace("{rule}", pattern);
            source2.sendMessage(MessageUtils.formatMessage(message));
        }
    }

    private void handleRemoveCommand(CommandSource source2, String[] args2) {
        if (args2.length < 2) {
            source2.sendMessage(MessageUtils.formatMessage("&cUsage: /chatfilter remove <regex_pattern>"));
            return;
        }
        StringBuilder patternBuilder = new StringBuilder();
        for (int i = 1; i < args2.length; ++i) {
            if (i > 1) {
                patternBuilder.append(" ");
            }
            patternBuilder.append(args2[i]);
        }
        String pattern = patternBuilder.toString();
        if (this.plugin.getChatControlManager().removeFilterRule(pattern, true)) {
            String message = this.plugin.getConfigManager().getChatFilterRuleRemovedMessage().replace("{rule}", pattern);
            source2.sendMessage(MessageUtils.formatMessage(message));
        } else {
            String message = this.plugin.getConfigManager().getChatFilterRuleNotFoundMessage().replace("{rule}", pattern);
            source2.sendMessage(MessageUtils.formatMessage(message));
        }
    }

    private void handleListCommand(CommandSource source2) {
        List<String> rules = this.plugin.getChatControlManager().getFilterRules();
        if (rules.isEmpty()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatFilterListEmptyMessage()));
            return;
        }
        source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatFilterListHeaderMessage()));
        String listFormat = this.plugin.getConfigManager().getChatFilterListFormatMessage();
        for (String rule : rules) {
            String formattedRule = listFormat.replace("{rule}", rule);
            source2.sendMessage(MessageUtils.formatMessage(formattedRule));
        }
    }

    private void handleReloadCommand(CommandSource source2) {
        String reloadPermission = this.plugin.getConfigManager().getChatFilterReloadPermission();
        if (source2 instanceof Player && !reloadPermission.isEmpty() && !source2.hasPermission(reloadPermission)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlNoPermissionMessage()));
            return;
        }
        try {
            this.plugin.getChatControlManager().loadFilterRules();
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlReloadSuccessMessage()));
        }
        catch (Exception e) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlReloadFailedMessage()));
            this.plugin.getLogger().error("Failed to reload chat filter configuration", e);
        }
    }

    private void handleClearCommand(CommandSource source2) {
        this.plugin.getChatControlManager().getFilterRules().clear();
        source2.sendMessage(MessageUtils.formatMessage("&aAll filter rules have been temporarily cleared. Use '/chatfilter reload' to restore from config."));
    }

    private void sendUsage(CommandSource source2) {
        source2.sendMessage(MessageUtils.formatMessage("&6Chat Filter Commands:"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatfilter add <pattern> &8- &fAdd a new filter rule"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatfilter remove <pattern> &8- &fRemove a filter rule"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatfilter list &8- &fList all active filter rules"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatfilter reload &8- &fReload filter configuration"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatfilter clear &8- &fTemporarily clear all rules"));
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        ArrayList<String> suggestions;
        block3: {
            String[] args2;
            block2: {
                args2 = (String[])invocation.arguments();
                suggestions = new ArrayList<String>();
                if (args2.length != 1) break block2;
                String input = args2[0].toLowerCase();
                List<String> subCommands = List.of("add", "remove", "list", "reload", "clear");
                for (String subCommand : subCommands) {
                    if (!subCommand.startsWith(input)) continue;
                    suggestions.add(subCommand);
                }
                break block3;
            }
            if (args2.length != 2 || !args2[0].equalsIgnoreCase("remove")) break block3;
            String input = args2[1].toLowerCase();
            for (String rule : this.plugin.getChatControlManager().getFilterRules()) {
                if (!rule.toLowerCase().startsWith(input)) continue;
                suggestions.add(rule);
            }
        }
        return CompletableFuture.completedFuture(suggestions);
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        if (invocation.source() instanceof ConsoleCommandSource) {
            return true;
        }
        String managePermission = this.plugin.getConfigManager().getChatFilterManagePermission();
        return managePermission.isEmpty() || invocation.source().hasPermission(managePermission);
    }
}

