/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ChatCooldownCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;

    public ChatCooldownCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String subCommand;
        CommandSource source2 = invocation.source();
        String[] args2 = (String[])invocation.arguments();
        if (!this.plugin.isChatControlModuleEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlModuleDisabledMessage()));
            return;
        }
        if (!this.plugin.getConfigManager().isChatCooldownEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlModuleDisabledMessage()));
            return;
        }
        String managePermission = this.plugin.getConfigManager().getChatCooldownManagePermission();
        if (source2 instanceof Player && !managePermission.isEmpty() && !source2.hasPermission(managePermission)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlNoPermissionMessage()));
            return;
        }
        if (args2.length == 0) {
            this.sendUsage(source2);
            return;
        }
        switch (subCommand = args2[0].toLowerCase()) {
            case "set": {
                this.handleSetCommand(source2, args2);
                break;
            }
            case "status": 
            case "info": {
                this.handleStatusCommand(source2);
                break;
            }
            case "clear": {
                this.handleClearCommand(source2);
                break;
            }
            case "reload": {
                this.handleReloadCommand(source2);
                break;
            }
            case "check": {
                this.handleCheckCommand(source2, args2);
                break;
            }
            default: {
                this.sendUsage(source2);
            }
        }
    }

    private void handleSetCommand(CommandSource source2, String[] args2) {
        if (args2.length < 2) {
            source2.sendMessage(MessageUtils.formatMessage("&cUsage: /chatcooldown set <duration_in_seconds>"));
            return;
        }
        try {
            int duration = Integer.parseInt(args2[1]);
            if (duration < 0) {
                source2.sendMessage(MessageUtils.formatMessage("&cDuration cannot be negative."));
                return;
            }
            this.plugin.getConfigManager().setChatCooldownDuration(duration);
            if (duration == 0) {
                source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatCooldownDurationDisabledMessage()));
            } else {
                String message = this.plugin.getConfigManager().getChatCooldownDurationSetMessage().replace("{duration}", String.valueOf(duration));
                source2.sendMessage(MessageUtils.formatMessage(message));
            }
        }
        catch (NumberFormatException e) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatCooldownInvalidDurationMessage()));
        }
    }

    private void handleStatusCommand(CommandSource source2) {
        int duration = this.plugin.getConfigManager().getChatCooldownDuration();
        if (duration <= 0) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatCooldownStatusDisabledMessage()));
        } else {
            String message = this.plugin.getConfigManager().getChatCooldownStatusEnabledMessage().replace("{duration}", String.valueOf(duration));
            source2.sendMessage(MessageUtils.formatMessage(message));
        }
        if (this.plugin.getConfigManager().isChatCooldownPermissionBasedEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage("&7Permission-based cooldowns are enabled:"));
            this.plugin.getConfigManager().getChatCooldownPermissionDurations().forEach((permission, permDuration) -> source2.sendMessage(MessageUtils.formatMessage("&7- " + permission + ": " + permDuration + "s")));
        }
        source2.sendMessage(MessageUtils.formatMessage("&7Active cooldown entries: " + this.plugin.getChatControlManager().getActiveCooldownCount()));
    }

    private void handleClearCommand(CommandSource source2) {
        this.plugin.getChatControlManager().clearCooldowns();
        source2.sendMessage(MessageUtils.formatMessage("&aAll active cooldowns have been cleared."));
    }

    private void handleReloadCommand(CommandSource source2) {
        String reloadPermission = this.plugin.getConfigManager().getChatCooldownReloadPermission();
        if (source2 instanceof Player && !reloadPermission.isEmpty() && !source2.hasPermission(reloadPermission)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlNoPermissionMessage()));
            return;
        }
        try {
            this.plugin.getConfigManager().loadConfig();
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlReloadSuccessMessage()));
        }
        catch (Exception e) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getChatControlReloadFailedMessage()));
            this.plugin.getLogger().error("Failed to reload chat cooldown configuration", e);
        }
    }

    private void handleCheckCommand(CommandSource source2, String[] args2) {
        if (args2.length < 2) {
            source2.sendMessage(MessageUtils.formatMessage("&cUsage: /chatcooldown check <player>"));
            return;
        }
        String playerName = args2[1];
        Player targetPlayer = this.plugin.getServer().getPlayer(playerName).orElse(null);
        if (targetPlayer == null) {
            source2.sendMessage(MessageUtils.formatMessage("&cPlayer not found: " + playerName));
            return;
        }
        long remainingTime = this.plugin.getChatControlManager().getRemainingCooldown(targetPlayer);
        if (remainingTime <= 0L) {
            source2.sendMessage(MessageUtils.formatMessage("&a" + playerName + " is not on cooldown."));
        } else {
            source2.sendMessage(MessageUtils.formatMessage("&e" + playerName + " has " + remainingTime + " seconds remaining on cooldown."));
        }
        String bypassPermission = this.plugin.getConfigManager().getChatCooldownBypassPermission();
        if (!bypassPermission.isEmpty() && targetPlayer.hasPermission(bypassPermission)) {
            source2.sendMessage(MessageUtils.formatMessage("&7" + playerName + " has cooldown bypass permission."));
        }
    }

    private void sendUsage(CommandSource source2) {
        source2.sendMessage(MessageUtils.formatMessage("&6Chat Cooldown Commands:"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatcooldown set <seconds> &8- &fSet cooldown duration"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatcooldown status &8- &fShow current cooldown settings"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatcooldown clear &8- &fClear all active cooldowns"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatcooldown check <player> &8- &fCheck a player's cooldown status"));
        source2.sendMessage(MessageUtils.formatMessage("&7/chatcooldown reload &8- &fReload cooldown configuration"));
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        String[] args2 = (String[])invocation.arguments();
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args2.length == 1) {
            String input = args2[0].toLowerCase();
            List<String> subCommands = List.of("set", "status", "clear", "reload", "check");
            for (String subCommand : subCommands) {
                if (!subCommand.startsWith(input)) continue;
                suggestions.add(subCommand);
            }
        } else if (args2.length == 2) {
            if (args2[0].equalsIgnoreCase("set")) {
                String input = args2[1];
                List<String> durations = List.of("0", "1", "2", "3", "5", "10", "15", "30");
                for (String duration : durations) {
                    if (!duration.startsWith(input)) continue;
                    suggestions.add(duration);
                }
            } else if (args2[0].equalsIgnoreCase("check")) {
                String input = args2[1].toLowerCase();
                this.plugin.getServer().getAllPlayers().forEach(player -> {
                    if (player.getUsername().toLowerCase().startsWith(input)) {
                        suggestions.add(player.getUsername());
                    }
                });
            }
        }
        return CompletableFuture.completedFuture(suggestions);
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        if (invocation.source() instanceof ConsoleCommandSource) {
            return true;
        }
        String managePermission = this.plugin.getConfigManager().getChatCooldownManagePermission();
        return managePermission.isEmpty() || invocation.source().hasPermission(managePermission);
    }
}

