/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class BMSProxyCoreCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;
    private static final String RELOAD_PERMISSION = "bmsproxycore.admin.reload";
    private static final String INFO_PERMISSION = "bmsproxycore.admin.info";

    public BMSProxyCoreCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String subCommand;
        CommandSource source2 = invocation.source();
        String[] args2 = (String[])invocation.arguments();
        if (args2.length == 0) {
            this.sendHelp(source2);
            return;
        }
        switch (subCommand = args2[0].toLowerCase()) {
            case "reload": {
                this.handleReload(source2);
                break;
            }
            case "status": 
            case "info": {
                this.handleStatus(source2);
                break;
            }
            case "modules": {
                this.handleModules(source2);
                break;
            }
            default: {
                this.sendHelp(source2);
            }
        }
    }

    private void handleReload(CommandSource source2) {
        if (!source2.hasPermission(RELOAD_PERMISSION)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        source2.sendMessage(MessageUtils.formatMessage("&eReloading BMSProxyCore configuration..."));
        BMSProxyCore.ReloadResult result = this.plugin.reloadConfiguration();
        if (result.success) {
            source2.sendMessage(MessageUtils.formatMessage("&a&lConfiguration Reload Complete!"));
            if (!result.changes.isEmpty()) {
                source2.sendMessage(MessageUtils.formatMessage("&6Changes made:"));
                for (String change : result.changes) {
                    source2.sendMessage(MessageUtils.formatMessage("&7- " + change));
                }
            }
            source2.sendMessage(MessageUtils.formatMessage("&6Module Status:"));
            source2.sendMessage(MessageUtils.formatMessage("&7- Staff Chat: " + (this.plugin.isStaffChatModuleEnabled() ? "&aEnabled" : "&cDisabled")));
            source2.sendMessage(MessageUtils.formatMessage("&7- Private Messages: " + (this.plugin.isPrivateMessagesModuleEnabled() ? "&aEnabled" : "&cDisabled")));
            source2.sendMessage(MessageUtils.formatMessage("&7- Lobby Command: " + (this.plugin.isLobbyCommandModuleEnabled() ? "&aEnabled" : "&cDisabled")));
        } else {
            source2.sendMessage(MessageUtils.formatMessage("&c&lReload Failed!"));
            if (result.error != null) {
                source2.sendMessage(MessageUtils.formatMessage("&cError: " + result.error));
            }
        }
    }

    private void handleStatus(CommandSource source2) {
        boolean privateMessagesEnabled;
        if (!source2.hasPermission(INFO_PERMISSION)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        source2.sendMessage(MessageUtils.formatMessage("&b&lBMSProxyCore Status"));
        source2.sendMessage(MessageUtils.formatMessage("&7Version: &f1.0.2"));
        source2.sendMessage(MessageUtils.formatMessage(""));
        source2.sendMessage(MessageUtils.formatMessage("&6Module Status:"));
        boolean staffChatEnabled = this.plugin.isStaffChatModuleEnabled();
        source2.sendMessage(MessageUtils.formatMessage("&7- Staff Chat: " + (staffChatEnabled ? "&aEnabled" : "&cDisabled")));
        if (staffChatEnabled) {
            boolean discordEnabled = this.plugin.getConfigManager().isDiscordEnabled();
            source2.sendMessage(MessageUtils.formatMessage("  &7- Discord Integration: " + (discordEnabled ? "&aEnabled" : "&cDisabled")));
        }
        source2.sendMessage(MessageUtils.formatMessage("&7- Private Messages: " + ((privateMessagesEnabled = this.plugin.isPrivateMessagesModuleEnabled()) ? "&aEnabled" : "&cDisabled")));
        boolean lobbyCommandEnabled = this.plugin.isLobbyCommandModuleEnabled();
        source2.sendMessage(MessageUtils.formatMessage("&7- Lobby Command: " + (lobbyCommandEnabled ? "&aEnabled" : "&cDisabled")));
        if (lobbyCommandEnabled) {
            String targetServer = this.plugin.getConfigManager().getLobbyTargetServer();
            source2.sendMessage(MessageUtils.formatMessage("  &7- Target Server: &f" + targetServer));
        }
    }

    private void handleModules(CommandSource source2) {
        if (!source2.hasPermission(INFO_PERMISSION)) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getNoPermissionMessage()));
            return;
        }
        source2.sendMessage(MessageUtils.formatMessage("&b&lBMSProxyCore Modules"));
        source2.sendMessage(MessageUtils.formatMessage(""));
        boolean staffChatEnabled = this.plugin.isStaffChatModuleEnabled();
        source2.sendMessage(MessageUtils.formatMessage("&6Staff Chat Module: " + (staffChatEnabled ? "&aEnabled" : "&cDisabled")));
        source2.sendMessage(MessageUtils.formatMessage("&7- Commands: /staffchat, /staffchattoggle"));
        source2.sendMessage(MessageUtils.formatMessage("&7- Features: Staff messaging, Discord integration, Activity tracking"));
        if (staffChatEnabled) {
            boolean discordEnabled = this.plugin.getConfigManager().isDiscordEnabled();
            source2.sendMessage(MessageUtils.formatMessage("&7- Discord: " + (discordEnabled ? "&aEnabled" : "&cDisabled")));
        }
        source2.sendMessage(MessageUtils.formatMessage(""));
        boolean privateMessagesEnabled = this.plugin.isPrivateMessagesModuleEnabled();
        source2.sendMessage(MessageUtils.formatMessage("&6Private Messages Module: " + (privateMessagesEnabled ? "&aEnabled" : "&cDisabled")));
        source2.sendMessage(MessageUtils.formatMessage("&7- Commands: /msg, /reply, /socialspy, /msgtoggle, /ignore"));
        source2.sendMessage(MessageUtils.formatMessage("&7- Features: Private messaging, Social spy, Ignore system"));
        source2.sendMessage(MessageUtils.formatMessage(""));
        boolean lobbyCommandEnabled = this.plugin.isLobbyCommandModuleEnabled();
        source2.sendMessage(MessageUtils.formatMessage("&6Lobby Command Module: " + (lobbyCommandEnabled ? "&aEnabled" : "&cDisabled")));
        if (lobbyCommandEnabled) {
            String mainCommand = this.plugin.getConfigManager().getLobbyMainCommand();
            List<String> aliases = this.plugin.getConfigManager().getLobbyCommandAliases();
            String targetServer = this.plugin.getConfigManager().getLobbyTargetServer();
            int cooldown = this.plugin.getConfigManager().getLobbyCooldown();
            source2.sendMessage(MessageUtils.formatMessage("&7- Main Command: /" + mainCommand));
            source2.sendMessage(MessageUtils.formatMessage("&7- Aliases: " + String.join((CharSequence)", ", (CharSequence[])aliases.stream().map(alias -> "/" + alias).toArray(String[]::new))));
            source2.sendMessage(MessageUtils.formatMessage("&7- Target Server: " + targetServer));
            source2.sendMessage(MessageUtils.formatMessage("&7- Cooldown: " + (String)(cooldown > 0 ? cooldown + " seconds" : "Disabled")));
        } else {
            source2.sendMessage(MessageUtils.formatMessage("&7- Commands: /lobby, /hub (when enabled)"));
        }
        source2.sendMessage(MessageUtils.formatMessage("&7- Features: Server teleportation, Cooldown system"));
    }

    private void sendHelp(CommandSource source2) {
        source2.sendMessage(MessageUtils.formatMessage("&b&lBMSProxyCore &7- &fModular Proxy System"));
        source2.sendMessage(MessageUtils.formatMessage("&7Available commands:"));
        source2.sendMessage(MessageUtils.formatMessage("&e/bmsproxycore reload &7- Reload configuration and modules"));
        source2.sendMessage(MessageUtils.formatMessage("&e/bmsproxycore status &7- Show plugin and module status"));
        source2.sendMessage(MessageUtils.formatMessage("&e/bmsproxycore modules &7- Show detailed module information"));
        source2.sendMessage(MessageUtils.formatMessage(""));
        source2.sendMessage(MessageUtils.formatMessage("&7Module commands (when enabled):"));
        if (this.plugin.isStaffChatModuleEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage("&a/staffchat <message> &7- Send a message to staff chat"));
            source2.sendMessage(MessageUtils.formatMessage("&a/staffchattoggle &7- Toggle staff chat mode"));
        } else {
            source2.sendMessage(MessageUtils.formatMessage("&c/staffchat, /staffchattoggle &7- (Staff Chat module disabled)"));
        }
        if (this.plugin.isPrivateMessagesModuleEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage("&a/msg <player> <message> &7- Send a private message"));
            source2.sendMessage(MessageUtils.formatMessage("&a/reply <message> &7- Reply to last message"));
            source2.sendMessage(MessageUtils.formatMessage("&a/socialspy &7- Toggle social spy"));
            source2.sendMessage(MessageUtils.formatMessage("&a/msgtoggle &7- Toggle message acceptance"));
            source2.sendMessage(MessageUtils.formatMessage("&a/ignore <add|remove|list> [player] &7- Manage ignored players"));
        } else {
            source2.sendMessage(MessageUtils.formatMessage("&c/msg, /reply, /socialspy, /msgtoggle, /ignore &7- (Private Messages module disabled)"));
        }
        if (this.plugin.isLobbyCommandModuleEnabled()) {
            String mainCommand = this.plugin.getConfigManager().getLobbyMainCommand();
            List<String> aliases = this.plugin.getConfigManager().getLobbyCommandAliases();
            String commandList = "/" + mainCommand;
            if (!aliases.isEmpty()) {
                commandList = commandList + ", /" + String.join((CharSequence)", /", aliases);
            }
            source2.sendMessage(MessageUtils.formatMessage("&a" + commandList + " &7- Teleport to lobby server"));
        } else {
            source2.sendMessage(MessageUtils.formatMessage("&c/lobby, /hub &7- (Lobby Command module disabled)"));
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        String[] args2 = (String[])invocation.arguments();
        if (args2.length == 1) {
            return CompletableFuture.completedFuture(List.of("reload", "status", "info", "modules"));
        }
        return CompletableFuture.completedFuture(List.of());
    }
}

