/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.commands;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.minecraftbangladesh.bmsproxycore.utils.MessageUtils;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;

public class AnnouncementCommand
implements SimpleCommand {
    private final BMSProxyCore plugin;

    public AnnouncementCommand(BMSProxyCore plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String announcement;
        CommandSource source2 = invocation.source();
        CharSequence[] args2 = (String[])invocation.arguments();
        if (!this.plugin.isAnnouncementModuleEnabled()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getModuleDisabledMessage()));
            return;
        }
        if (args2.length == 0) {
            String usageMessage = source2 instanceof ConsoleCommandSource ? this.plugin.getConfigManager().getAnnouncementConsoleUsageMessage() : this.plugin.getConfigManager().getAnnouncementUsageMessage();
            source2.sendMessage(MessageUtils.formatMessage(usageMessage.replace("{command}", "announce")));
            return;
        }
        if (source2 instanceof Player) {
            Player player = (Player)source2;
            String permission = this.plugin.getConfigManager().getAnnouncementSendPermission();
            if (!permission.isEmpty() && !player.hasPermission(permission)) {
                player.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getAnnouncementNoPermissionMessage()));
                return;
            }
        }
        if ((announcement = String.join((CharSequence)" ", args2)).trim().isEmpty()) {
            source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getAnnouncementEmptyMessage()));
            return;
        }
        this.sendAnnouncement(source2, announcement);
        source2.sendMessage(MessageUtils.formatMessage(this.plugin.getConfigManager().getAnnouncementSuccessMessage()));
    }

    private void sendAnnouncement(CommandSource sender, String announcement) {
        String senderName = "Console";
        String senderServer = "Console";
        if (sender instanceof Player) {
            Player player = (Player)sender;
            senderName = player.getUsername();
            senderServer = player.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("Unknown");
        }
        if (this.plugin.getConfigManager().isAnnouncementChatMessageEnabled()) {
            Component chatMessage = this.createChatMessage(sender, senderName, senderServer, announcement);
            for (Player player : this.plugin.getServer().getAllPlayers()) {
                player.sendMessage(chatMessage);
            }
            this.plugin.getLogger().info(MessageUtils.componentToPlainText(chatMessage));
        }
        if (this.plugin.getConfigManager().isAnnouncementTitleEnabled()) {
            Title title = this.createTitle(announcement);
            for (Player player : this.plugin.getServer().getAllPlayers()) {
                player.showTitle(title);
            }
        }
    }

    private Component createChatMessage(CommandSource sender, String senderName, String senderServer, String announcement) {
        String format = sender instanceof ConsoleCommandSource ? this.plugin.getConfigManager().getAnnouncementConsoleFormat() : (this.plugin.getConfigManager().isAnnouncementShowSender() ? this.plugin.getConfigManager().getAnnouncementSenderFormat().replace("{sender}", senderName).replace("{server}", senderServer) : this.plugin.getConfigManager().getAnnouncementChatMessageFormat());
        format = format.replace("{announcement}", announcement);
        return MessageUtils.formatMessage(format);
    }

    private Title createTitle(String announcement) {
        String mainTitleText = this.plugin.getConfigManager().getAnnouncementTitleMainTitle();
        String subtitleText = this.plugin.getConfigManager().getAnnouncementTitleSubtitle().replace("{announcement}", announcement);
        int fadeInTicks = this.plugin.getConfigManager().getAnnouncementTitleFadeIn();
        int stayTicks = this.plugin.getConfigManager().getAnnouncementTitleStay();
        int fadeOutTicks = this.plugin.getConfigManager().getAnnouncementTitleFadeOut();
        Duration fadeIn = Duration.ofMillis((long)fadeInTicks * 50L);
        Duration stay = Duration.ofMillis((long)stayTicks * 50L);
        Duration fadeOut = Duration.ofMillis((long)fadeOutTicks * 50L);
        Component mainTitle = MessageUtils.formatMessage(mainTitleText);
        Component subtitle = MessageUtils.formatMessage(subtitleText);
        return Title.title((Component)mainTitle, (Component)subtitle, (Title.Times)Title.Times.times((Duration)fadeIn, (Duration)stay, (Duration)fadeOut));
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(List.of());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        if (invocation.source() instanceof ConsoleCommandSource) {
            return true;
        }
        if (invocation.source() instanceof Player) {
            String permission = this.plugin.getConfigManager().getAnnouncementSendPermission();
            if (permission.isEmpty()) {
                return true;
            }
            return invocation.source().hasPermission(permission);
        }
        return false;
    }
}

