/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore.chatcontrol;

import com.minecraftbangladesh.bmsproxycore.BMSProxyCore;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ChatControlManager {
    private final BMSProxyCore plugin;
    private final List<Pattern> filterPatterns = new ArrayList<Pattern>();
    private final List<String> filterRules = new ArrayList<String>();
    private final Map<UUID, Long> lastMessageTime = new ConcurrentHashMap<UUID, Long>();
    private volatile boolean chatLocked = false;

    public ChatControlManager(BMSProxyCore plugin) {
        this.plugin = plugin;
        this.loadFilterRules();
    }

    public void loadFilterRules() {
        this.filterPatterns.clear();
        this.filterRules.clear();
        List<String> rules = this.plugin.getConfigManager().getChatFilterRules();
        for (String rule : rules) {
            this.addFilterRule(rule, false);
        }
        if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
            this.plugin.getLogger().info("[ChatControl-Debug] Loaded " + this.filterRules.size() + " filter rules");
        }
    }

    public boolean shouldFilterMessage(String message) {
        if (!this.plugin.getConfigManager().isChatFilterEnabled()) {
            return false;
        }
        for (Pattern pattern : this.filterPatterns) {
            if (!pattern.matcher(message).find()) continue;
            if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
                this.plugin.getLogger().info("[ChatControl-Debug] Message filtered by pattern: " + pattern.pattern());
            }
            return true;
        }
        return false;
    }

    public boolean canSendMessage(Player player) {
        long cooldownMillis;
        if (!this.plugin.getConfigManager().isChatCooldownEnabled()) {
            return true;
        }
        String bypassPermission = this.plugin.getConfigManager().getChatCooldownBypassPermission();
        if (!bypassPermission.isEmpty() && player.hasPermission(bypassPermission)) {
            return true;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastMessageTime.get(playerId);
        if (lastTime == null) {
            return true;
        }
        int cooldownDuration = this.getCooldownDuration(player);
        if (cooldownDuration <= 0) {
            return true;
        }
        long timeDiff = currentTime - lastTime;
        return timeDiff >= (cooldownMillis = (long)cooldownDuration * 1000L);
    }

    public long getRemainingCooldown(Player player) {
        long cooldownMillis;
        if (!this.plugin.getConfigManager().isChatCooldownEnabled()) {
            return 0L;
        }
        String bypassPermission = this.plugin.getConfigManager().getChatCooldownBypassPermission();
        if (!bypassPermission.isEmpty() && player.hasPermission(bypassPermission)) {
            return 0L;
        }
        UUID playerId = player.getUniqueId();
        Long lastTime = this.lastMessageTime.get(playerId);
        if (lastTime == null) {
            return 0L;
        }
        int cooldownDuration = this.getCooldownDuration(player);
        if (cooldownDuration <= 0) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long timeDiff = currentTime - lastTime;
        if (timeDiff >= (cooldownMillis = (long)cooldownDuration * 1000L)) {
            return 0L;
        }
        return (cooldownMillis - timeDiff) / 1000L + 1L;
    }

    public void setLastMessageTime(Player player) {
        if (this.plugin.getConfigManager().isChatCooldownEnabled()) {
            this.lastMessageTime.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    private int getCooldownDuration(Player player) {
        if (this.plugin.getConfigManager().isChatCooldownPermissionBasedEnabled()) {
            Map<String, Integer> permissionDurations = this.plugin.getConfigManager().getChatCooldownPermissionDurations();
            for (Map.Entry<String, Integer> entry : permissionDurations.entrySet()) {
                if (!player.hasPermission(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return this.plugin.getConfigManager().getChatCooldownDuration();
    }

    public boolean addFilterRule(String rule, boolean saveToConfig) {
        if (this.filterRules.contains(rule)) {
            return false;
        }
        try {
            Pattern pattern = Pattern.compile(rule, this.plugin.getConfigManager().isChatFilterCaseSensitive() ? 0 : 2);
            this.filterPatterns.add(pattern);
            this.filterRules.add(rule);
            if (saveToConfig) {
                this.plugin.getConfigManager().addChatFilterRule(rule);
            }
            if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
                this.plugin.getLogger().info("[ChatControl-Debug] Added filter rule: " + rule);
            }
            return true;
        }
        catch (PatternSyntaxException e) {
            if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
                this.plugin.getLogger().warn("[ChatControl-Debug] Invalid regex pattern: " + rule + " - " + e.getMessage());
            }
            return false;
        }
    }

    public boolean removeFilterRule(String rule, boolean saveToConfig) {
        int index = this.filterRules.indexOf(rule);
        if (index == -1) {
            return false;
        }
        this.filterRules.remove(index);
        this.filterPatterns.remove(index);
        if (saveToConfig) {
            this.plugin.getConfigManager().removeChatFilterRule(rule);
        }
        if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
            this.plugin.getLogger().info("[ChatControl-Debug] Removed filter rule: " + rule);
        }
        return true;
    }

    public List<String> getFilterRules() {
        return new ArrayList<String>(this.filterRules);
    }

    public void clearCooldowns() {
        this.lastMessageTime.clear();
        if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
            this.plugin.getLogger().info("[ChatControl-Debug] Cleared all cooldown data");
        }
    }

    public int getFilterRuleCount() {
        return this.filterRules.size();
    }

    public boolean isAtMaxFilterRules() {
        return this.filterRules.size() >= this.plugin.getConfigManager().getChatControlMaxFilterRules();
    }

    public int getActiveCooldownCount() {
        return this.lastMessageTime.size();
    }

    public boolean isChatLocked() {
        return this.chatLocked;
    }

    public void setChatLocked(boolean locked) {
        this.chatLocked = locked;
        if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
            this.plugin.getLogger().info("[ChatControl-Debug] Chat lock state changed to: " + (locked ? "LOCKED" : "UNLOCKED"));
        }
    }

    public boolean toggleChatLock() {
        boolean bl = this.chatLocked = !this.chatLocked;
        if (this.plugin.getConfigManager().isChatControlDebugEnabled()) {
            this.plugin.getLogger().info("[ChatControl-Debug] Chat lock toggled to: " + (this.chatLocked ? "LOCKED" : "UNLOCKED"));
        }
        return this.chatLocked;
    }

    public boolean canSendMessageWithChatLock(Player player) {
        if (!this.chatLocked) {
            return true;
        }
        String bypassPermission = this.plugin.getConfigManager().getLockChatBypassPermission();
        return !bypassPermission.isEmpty() && player.hasPermission(bypassPermission);
    }

    public String applyMessageFilter(String message, Player player) {
        if (!this.plugin.getConfigManager().isChatFilterEnabled()) {
            return message;
        }
        String bypassPermission = this.plugin.getConfigManager().getChatFilterBypassPrivateMessagesPermission();
        if (!bypassPermission.isEmpty() && player.hasPermission(bypassPermission)) {
            return message;
        }
        if (this.shouldFilterMessage(message)) {
            String action = this.plugin.getConfigManager().getChatFilterAction();
            switch (action.toLowerCase()) {
                case "block": 
                case "warn": {
                    return null;
                }
                case "replace": {
                    String replacementText = this.plugin.getConfigManager().getChatFilterReplacementText();
                    return this.replaceFilteredContent(message, replacementText);
                }
            }
            return message;
        }
        return message;
    }

    private String replaceFilteredContent(String message, String replacementText) {
        String result = message;
        for (String rule : this.getFilterRules()) {
            try {
                Object pattern = this.plugin.getConfigManager().isChatFilterCaseSensitive() ? rule : "(?i)" + rule;
                result = result.replaceAll((String)pattern, replacementText);
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isChatControlDebugEnabled()) continue;
                this.plugin.getLogger().warn("[ChatControl-Debug] Failed to apply replacement for rule: " + rule);
            }
        }
        return result;
    }
}

