/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftbangladesh.bmsproxycore;

import com.google.inject.Inject;
import com.minecraftbangladesh.bmsproxycore.chatcontrol.ChatControlManager;
import com.minecraftbangladesh.bmsproxycore.commands.AnnouncementCommand;
import com.minecraftbangladesh.bmsproxycore.commands.BMSProxyCoreCommand;
import com.minecraftbangladesh.bmsproxycore.commands.ChatCooldownCommand;
import com.minecraftbangladesh.bmsproxycore.commands.ChatFilterCommand;
import com.minecraftbangladesh.bmsproxycore.commands.ClearChatCommand;
import com.minecraftbangladesh.bmsproxycore.commands.IgnoreCommand;
import com.minecraftbangladesh.bmsproxycore.commands.LobbyCommand;
import com.minecraftbangladesh.bmsproxycore.commands.LockChatCommand;
import com.minecraftbangladesh.bmsproxycore.commands.MessageCommand;
import com.minecraftbangladesh.bmsproxycore.commands.MessageToggleCommand;
import com.minecraftbangladesh.bmsproxycore.commands.ReplyCommand;
import com.minecraftbangladesh.bmsproxycore.commands.SocialSpyCommand;
import com.minecraftbangladesh.bmsproxycore.commands.StaffChatCommand;
import com.minecraftbangladesh.bmsproxycore.commands.StaffChatToggleCommand;
import com.minecraftbangladesh.bmsproxycore.listeners.ChatControlListener;
import com.minecraftbangladesh.bmsproxycore.listeners.ChatListener;
import com.minecraftbangladesh.bmsproxycore.listeners.ConnectionListener;
import com.minecraftbangladesh.bmsproxycore.listeners.DisconnectListener;
import com.minecraftbangladesh.bmsproxycore.listeners.MessagingDisconnectListener;
import com.minecraftbangladesh.bmsproxycore.listeners.ServerSwitchListener;
import com.minecraftbangladesh.bmsproxycore.messaging.MessagingManager;
import com.minecraftbangladesh.bmsproxycore.redis.CrossProxyMessagingManager;
import com.minecraftbangladesh.bmsproxycore.redis.CrossProxyStaffChatManager;
import com.minecraftbangladesh.bmsproxycore.redis.RedisManager;
import com.minecraftbangladesh.bmsproxycore.utils.ConfigManager;
import com.minecraftbangladesh.bmsproxycore.utils.DiscordWebhook;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;

@Plugin(id="bmsproxycore", name="BMSProxyCore", version="1.0.2", description="A staff chat system for Velocity proxies", authors={"MinecraftBangladesh"})
public class BMSProxyCore {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private ConfigManager configManager;
    private DiscordWebhook discordWebhook;
    private MessagingManager messagingManager;
    private ChatControlManager chatControlManager;
    private RedisManager redisManager;
    private CrossProxyStaffChatManager crossProxyStaffChatManager;
    private CrossProxyMessagingManager crossProxyMessagingManager;
    private final Set<UUID> staffChatToggled = new HashSet<UUID>();

    @Inject
    public BMSProxyCore(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.configManager = new ConfigManager(this.dataDirectory);
        this.configManager.loadConfig();
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("bmsproxycore").plugin((Object)this).build(), (Command)new BMSProxyCoreCommand(this));
        this.initializeStaffChatModule();
        this.initializePrivateMessagesModule();
        this.initializeLobbyCommandModule();
        this.initializeAnnouncementModule();
        this.initializeChatControlModule();
        this.logger.info("BMSProxyCore has been enabled!");
    }

    private void initializeStaffChatModule() {
        if (!this.configManager.isStaffChatEnabled()) {
            this.logger.info("Staff Chat module is disabled in configuration.");
            return;
        }
        this.logger.info("Initializing Staff Chat module...");
        this.discordWebhook = new DiscordWebhook(this);
        if (this.configManager.isRedisEnabled()) {
            this.redisManager = new RedisManager(this);
            if (this.redisManager.initialize()) {
                this.crossProxyStaffChatManager = new CrossProxyStaffChatManager(this, this.redisManager);
                this.crossProxyStaffChatManager.initialize();
                this.logger.info("Redis cross-proxy staff chat enabled");
            } else {
                this.logger.warn("Failed to initialize Redis - cross-proxy staff chat will be disabled");
                this.redisManager = null;
            }
        } else {
            this.logger.info("Redis cross-proxy staff chat is disabled in configuration");
        }
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("staffchat").aliases(new String[]{"sc"}).plugin((Object)this).build(), (Command)new StaffChatCommand(this));
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("staffchattoggle").aliases(new String[]{"sctoggle"}).plugin((Object)this).build(), (Command)new StaffChatToggleCommand(this));
        this.server.getEventManager().register((Object)this, (Object)new ChatListener(this));
        this.server.getEventManager().register((Object)this, (Object)new DisconnectListener(this));
        this.server.getEventManager().register((Object)this, (Object)new ServerSwitchListener(this));
        this.server.getEventManager().register((Object)this, (Object)new ConnectionListener(this));
        this.logger.info("Staff Chat module initialized successfully.");
    }

    private void initializePrivateMessagesModule() {
        if (!this.configManager.isPrivateMessagesEnabled()) {
            this.logger.info("Private Messages module is disabled in configuration.");
            return;
        }
        this.logger.info("Initializing Private Messages module...");
        this.messagingManager = new MessagingManager(this);
        if (this.configManager.isPrivateMessagesRedisEnabled() && this.redisManager != null && this.redisManager.isConnected()) {
            this.crossProxyMessagingManager = new CrossProxyMessagingManager(this, this.redisManager);
            this.crossProxyMessagingManager.initialize();
            this.logger.info("Redis cross-proxy private messaging enabled");
        } else if (this.configManager.isPrivateMessagesRedisEnabled()) {
            this.logger.warn("Cross-proxy private messaging is enabled but Redis is not available");
        } else {
            this.logger.info("Redis cross-proxy private messaging is disabled in configuration");
        }
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("msg").aliases(new String[]{"whisper"}).plugin((Object)this).build(), (Command)new MessageCommand(this));
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("reply").aliases(new String[]{"r"}).plugin((Object)this).build(), (Command)new ReplyCommand(this));
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("socialspy").plugin((Object)this).build(), (Command)new SocialSpyCommand(this));
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("msgtoggle").plugin((Object)this).build(), (Command)new MessageToggleCommand(this));
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("ignore").plugin((Object)this).build(), (Command)new IgnoreCommand(this));
        this.server.getEventManager().register((Object)this, (Object)new MessagingDisconnectListener(this));
        this.logger.info("Private Messages module initialized successfully.");
    }

    private void initializeLobbyCommandModule() {
        if (!this.configManager.isLobbyCommandEnabled()) {
            this.logger.info("Lobby Command module is disabled in configuration.");
            return;
        }
        this.logger.info("Initializing Lobby Command module...");
        String mainCommand = this.configManager.getLobbyMainCommand();
        List<String> aliases = this.configManager.getLobbyCommandAliases();
        LobbyCommand lobbyCommand = new LobbyCommand(this);
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(mainCommand).aliases(aliases.toArray(new String[0])).plugin((Object)this).build(), (Command)lobbyCommand);
        this.logger.info("Lobby Command module initialized successfully.");
        this.logger.info("Registered command: /" + mainCommand + " with aliases: " + String.valueOf(aliases));
    }

    private void initializeAnnouncementModule() {
        if (!this.configManager.isAnnouncementEnabled()) {
            this.logger.info("Announcement module is disabled in configuration.");
            return;
        }
        this.logger.info("Initializing Announcement module...");
        String mainCommand = this.configManager.getAnnouncementMainCommand();
        List<String> aliases = this.configManager.getAnnouncementCommandAliases();
        AnnouncementCommand announcementCommand = new AnnouncementCommand(this);
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(mainCommand).aliases(aliases.toArray(new String[0])).plugin((Object)this).build(), (Command)announcementCommand);
        this.logger.info("Announcement module initialized successfully.");
        this.logger.info("Registered command: /" + mainCommand + " with aliases: " + String.valueOf(aliases));
    }

    private void initializeChatControlModule() {
        if (!this.configManager.isChatControlEnabled()) {
            this.logger.info("Chat Control module is disabled in configuration.");
            return;
        }
        this.logger.info("Initializing Chat Control module...");
        this.chatControlManager = new ChatControlManager(this);
        this.server.getEventManager().register((Object)this, (Object)new ChatControlListener(this));
        if (this.configManager.isChatFilterEnabled()) {
            String filterMainCommand = this.configManager.getChatFilterMainCommand();
            List<String> filterAliases = this.configManager.getChatFilterCommandAliases();
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(filterMainCommand).aliases(filterAliases.toArray(new String[0])).plugin((Object)this).build(), (Command)new ChatFilterCommand(this));
            this.logger.info("Chat Filter component initialized with command: /" + filterMainCommand);
        }
        if (this.configManager.isChatCooldownEnabled()) {
            String cooldownMainCommand = this.configManager.getChatCooldownMainCommand();
            List<String> cooldownAliases = this.configManager.getChatCooldownCommandAliases();
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(cooldownMainCommand).aliases(cooldownAliases.toArray(new String[0])).plugin((Object)this).build(), (Command)new ChatCooldownCommand(this));
            this.logger.info("Chat Cooldown component initialized with command: /" + cooldownMainCommand);
        }
        if (this.configManager.isClearChatEnabled()) {
            String clearChatMainCommand = this.configManager.getClearChatMainCommand();
            List<String> clearChatAliases = this.configManager.getClearChatCommandAliases();
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(clearChatMainCommand).aliases(clearChatAliases.toArray(new String[0])).plugin((Object)this).build(), (Command)new ClearChatCommand(this));
            this.logger.info("Clear Chat component initialized with command: /" + clearChatMainCommand);
        }
        if (this.configManager.isLockChatEnabled()) {
            String lockChatMainCommand = this.configManager.getLockChatMainCommand();
            List<String> lockChatAliases = this.configManager.getLockChatCommandAliases();
            this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder(lockChatMainCommand).aliases(lockChatAliases.toArray(new String[0])).plugin((Object)this).build(), (Command)new LockChatCommand(this));
            this.logger.info("Lock Chat component initialized with command: /" + lockChatMainCommand);
        }
        this.logger.info("Chat Control module initialized successfully.");
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DiscordWebhook getDiscordWebhook() {
        return this.discordWebhook;
    }

    public MessagingManager getMessagingManager() {
        return this.messagingManager;
    }

    public boolean isStaffChatModuleEnabled() {
        return this.configManager.isStaffChatEnabled();
    }

    public boolean isPrivateMessagesModuleEnabled() {
        return this.configManager.isPrivateMessagesEnabled();
    }

    public boolean isLobbyCommandModuleEnabled() {
        return this.configManager.isLobbyCommandEnabled();
    }

    public boolean isChatControlModuleEnabled() {
        return this.configManager.isChatControlEnabled();
    }

    public ChatControlManager getChatControlManager() {
        return this.chatControlManager;
    }

    public boolean isAnnouncementModuleEnabled() {
        return this.configManager.isAnnouncementEnabled();
    }

    public RedisManager getRedisManager() {
        return this.redisManager;
    }

    public CrossProxyStaffChatManager getCrossProxyStaffChatManager() {
        return this.crossProxyStaffChatManager;
    }

    public CrossProxyMessagingManager getCrossProxyMessagingManager() {
        return this.crossProxyMessagingManager;
    }

    public ReloadResult reloadConfiguration() {
        ReloadResult result = new ReloadResult();
        try {
            boolean wasStaffChatEnabled = this.configManager.isStaffChatEnabled();
            boolean wasPrivateMessagesEnabled = this.configManager.isPrivateMessagesEnabled();
            boolean wasLobbyCommandEnabled = this.configManager.isLobbyCommandEnabled();
            boolean wasAnnouncementEnabled = this.configManager.isAnnouncementEnabled();
            boolean wasChatControlEnabled = this.configManager.isChatControlEnabled();
            this.configManager.loadConfig();
            result.configReloaded = true;
            boolean isStaffChatEnabled = this.configManager.isStaffChatEnabled();
            boolean isPrivateMessagesEnabled = this.configManager.isPrivateMessagesEnabled();
            boolean isLobbyCommandEnabled = this.configManager.isLobbyCommandEnabled();
            boolean isAnnouncementEnabled = this.configManager.isAnnouncementEnabled();
            boolean isChatControlEnabled = this.configManager.isChatControlEnabled();
            if (wasStaffChatEnabled != isStaffChatEnabled) {
                if (isStaffChatEnabled) {
                    this.initializeStaffChatModule();
                    result.staffChatEnabled = true;
                    result.changes.add("Staff Chat module enabled");
                } else {
                    this.shutdownStaffChatModule();
                    result.staffChatDisabled = true;
                    result.changes.add("Staff Chat module disabled");
                }
            } else if (isStaffChatEnabled) {
                result.changes.add("Staff Chat configuration reloaded");
            }
            if (wasPrivateMessagesEnabled != isPrivateMessagesEnabled) {
                if (isPrivateMessagesEnabled) {
                    this.initializePrivateMessagesModule();
                    result.privateMessagesEnabled = true;
                    result.changes.add("Private Messages module enabled");
                } else {
                    this.shutdownPrivateMessagesModule();
                    result.privateMessagesDisabled = true;
                    result.changes.add("Private Messages module disabled");
                }
            } else if (isPrivateMessagesEnabled) {
                result.changes.add("Private Messages configuration reloaded");
            }
            if (wasLobbyCommandEnabled != isLobbyCommandEnabled) {
                if (isLobbyCommandEnabled) {
                    this.initializeLobbyCommandModule();
                    result.changes.add("Lobby Command module enabled");
                } else {
                    result.changes.add("Lobby Command module disabled");
                }
            } else if (isLobbyCommandEnabled) {
                result.changes.add("Lobby Command configuration reloaded");
            }
            if (wasAnnouncementEnabled != isAnnouncementEnabled) {
                if (isAnnouncementEnabled) {
                    this.initializeAnnouncementModule();
                    result.changes.add("Announcement module enabled");
                } else {
                    result.changes.add("Announcement module disabled");
                }
            } else if (isAnnouncementEnabled) {
                result.changes.add("Announcement configuration reloaded");
            }
            if (wasChatControlEnabled != isChatControlEnabled) {
                if (isChatControlEnabled) {
                    this.initializeChatControlModule();
                    result.changes.add("Chat Control module enabled");
                } else {
                    this.shutdownChatControlModule();
                    result.changes.add("Chat Control module disabled");
                }
            } else if (isChatControlEnabled) {
                if (this.chatControlManager != null) {
                    this.chatControlManager.loadFilterRules();
                }
                result.changes.add("Chat Control configuration reloaded");
            }
            result.success = true;
        }
        catch (Exception e) {
            result.success = false;
            result.error = e.getMessage();
            this.logger.error("Failed to reload configuration", e);
        }
        return result;
    }

    private void shutdownStaffChatModule() {
        this.logger.info("Shutting down Staff Chat module...");
        if (this.crossProxyStaffChatManager != null) {
            this.crossProxyStaffChatManager.shutdown();
            this.crossProxyStaffChatManager = null;
        }
        if (this.redisManager != null) {
            this.redisManager.shutdown();
            this.redisManager = null;
        }
        this.discordWebhook = null;
        this.logger.info("Staff Chat module shut down.");
    }

    private void shutdownPrivateMessagesModule() {
        this.logger.info("Shutting down Private Messages module...");
        if (this.crossProxyMessagingManager != null) {
            this.crossProxyMessagingManager.shutdown();
            this.crossProxyMessagingManager = null;
        }
        this.messagingManager = null;
        this.logger.info("Private Messages module shut down.");
    }

    private void shutdownChatControlModule() {
        this.logger.info("Shutting down Chat Control module...");
        this.chatControlManager = null;
        this.logger.info("Chat Control module shut down.");
    }

    public Set<UUID> getStaffChatToggled() {
        return this.staffChatToggled;
    }

    public boolean isStaffChatToggled(UUID uuid) {
        return this.staffChatToggled.contains(uuid);
    }

    public void toggleStaffChat(UUID uuid) {
        if (this.staffChatToggled.contains(uuid)) {
            this.staffChatToggled.remove(uuid);
        } else {
            this.staffChatToggled.add(uuid);
        }
    }

    public void sendStaffChatMessage(Player sender, String message) {
        if (!this.isStaffChatModuleEnabled()) {
            return;
        }
        if (this.discordWebhook != null && this.configManager.isDiscordEnabled()) {
            String serverName = sender.getCurrentServer().map(serverConnection -> serverConnection.getServerInfo().getName()).orElse("Unknown");
            this.discordWebhook.sendStaffChatMessage(sender, message, serverName);
        }
        if (this.crossProxyStaffChatManager != null && this.configManager.isRedisEnabled()) {
            this.crossProxyStaffChatManager.broadcastStaffChatMessage(sender, message);
        }
    }

    public void sendConsoleStaffChatMessage(String message) {
        if (!this.isStaffChatModuleEnabled()) {
            return;
        }
        if (this.discordWebhook != null && this.configManager.isDiscordEnabled()) {
            this.discordWebhook.sendConsoleStaffChatMessage(message);
        }
        if (this.crossProxyStaffChatManager != null && this.configManager.isRedisEnabled()) {
            this.crossProxyStaffChatManager.broadcastConsoleStaffChatMessage(message);
        }
    }

    public void sendStaffServerSwitchMessage(Player player, String fromServer, String toServer) {
        if (!this.isStaffChatModuleEnabled()) {
            return;
        }
        if (this.discordWebhook != null && this.configManager.isDiscordEnabled()) {
            this.discordWebhook.sendStaffServerSwitchMessage(player, fromServer, toServer);
        }
        if (this.crossProxyStaffChatManager != null && this.configManager.isRedisEnabled()) {
            this.crossProxyStaffChatManager.broadcastPlayerServerSwitch(player, fromServer, toServer);
        }
    }

    public void sendStaffConnectMessage(Player player) {
        if (!this.isStaffChatModuleEnabled()) {
            return;
        }
        if (this.discordWebhook != null && this.configManager.isDiscordEnabled()) {
            this.discordWebhook.sendStaffConnectMessage(player);
        }
        if (this.crossProxyStaffChatManager != null && this.configManager.isRedisEnabled()) {
            this.crossProxyStaffChatManager.broadcastPlayerConnect(player);
        }
    }

    public void sendStaffDisconnectMessage(Player player) {
        if (!this.isStaffChatModuleEnabled()) {
            return;
        }
        if (this.discordWebhook != null && this.configManager.isDiscordEnabled()) {
            this.discordWebhook.sendStaffDisconnectMessage(player);
        }
        if (this.crossProxyStaffChatManager != null && this.configManager.isRedisEnabled()) {
            this.crossProxyStaffChatManager.broadcastPlayerDisconnect(player);
        }
    }

    public static class ReloadResult {
        public boolean success = false;
        public boolean configReloaded = false;
        public boolean staffChatEnabled = false;
        public boolean staffChatDisabled = false;
        public boolean privateMessagesEnabled = false;
        public boolean privateMessagesDisabled = false;
        public String error = null;
        public List<String> changes = new ArrayList<String>();
    }
}

