/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.listeners;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.personalphantoms.PersonalPhantoms;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingListener;

public class MobListener
extends AnnoyingListener {
    @NotNull
    private final PersonalPhantoms plugin;

    public MobListener(@NotNull PersonalPhantoms plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public PersonalPhantoms getAnnoyingPlugin() {
        return this.plugin;
    }

    @EventHandler
    public void onEntityTargetLivingEntity(@NotNull EntityTargetLivingEntityEvent event) {
        if (event.getEntity().getType() != EntityType.PHANTOM) {
            return;
        }
        LivingEntity target = event.getTarget();
        if (target instanceof Player && this.plugin.isWhitelistedWorld(target.getWorld()) && !this.plugin.hasPhantomsEnabled((OfflinePlayer)((Player)target))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (!this.plugin.isWhitelistedWorld(damager.getWorld())) {
            return;
        }
        Entity target = event.getEntity();
        if (damager instanceof Player && target.getType() == EntityType.PHANTOM && !this.plugin.hasPhantomsEnabled((OfflinePlayer)((Player)damager))) {
            event.setCancelled(true);
            return;
        }
        if (damager.getType() == EntityType.PHANTOM && target instanceof Player && !this.plugin.hasPhantomsEnabled((OfflinePlayer)((Player)target))) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isWhitelistedWorld(player.getWorld()) && !this.plugin.hasPhantomsEnabled((OfflinePlayer)player)) {
            PersonalPhantoms.resetStatistic(player);
        }
    }
}

