/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.scheduler;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.personalphantoms.libs.annoyingapi.parents.Annoyable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.scheduler.TaskWrapper;

public class AnnoyingScheduler
implements Annoyable {
    @NotNull
    private final AnnoyingPlugin plugin;

    public AnnoyingScheduler(@NotNull AnnoyingPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public AnnoyingPlugin getAnnoyingPlugin() {
        return this.plugin;
    }

    @NotNull
    public TaskWrapper runSync(@NotNull Runnable runnable) {
        if (AnnoyingPlugin.FOLIA) {
            try {
                Object scheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
                return new TaskWrapper(scheduler.getClass().getMethod("run", Plugin.class, Consumer.class).invoke(scheduler, new Object[]{this.plugin, new FoliaConsumer(runnable)}));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Failed to run a Folia task!", e);
            }
        }
        return new TaskWrapper(Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable));
    }

    @NotNull
    public Optional<TaskWrapper> attemptAsync(@NotNull Runnable runnable) {
        try {
            return Optional.of(new TaskWrapper(Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable)));
        }
        catch (UnsupportedOperationException | IllegalPluginAccessException e) {
            if (e instanceof UnsupportedOperationException && AnnoyingPlugin.FOLIA) {
                return Optional.of(this.runSync(runnable));
            }
            runnable.run();
            return Optional.empty();
        }
    }

    @NotNull
    public TaskWrapper runGlobalTaskLater(@NotNull Runnable runnable, long delay) {
        if (AnnoyingPlugin.FOLIA) {
            return this.runGlobalTaskLaterFolia(runnable, delay);
        }
        return new TaskWrapper(Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, runnable, delay));
    }

    @NotNull
    public TaskWrapper runGlobalTaskLaterAsync(@NotNull Runnable runnable, long delay) {
        if (AnnoyingPlugin.FOLIA) {
            return this.runGlobalTaskLaterFolia(runnable, delay);
        }
        return new TaskWrapper(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, runnable, delay));
    }

    @NotNull
    private TaskWrapper runGlobalTaskLaterFolia(@NotNull Runnable runnable, long delay) {
        try {
            Object scheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            return new TaskWrapper(scheduler.getClass().getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE).invoke(scheduler, new Object[]{this.plugin, new FoliaConsumer(runnable), delay}));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to run a Folia task!", e);
        }
    }

    @NotNull
    public TaskWrapper runGlobalTaskTimer(@NotNull Runnable runnable, long delay, long interval) {
        if (AnnoyingPlugin.FOLIA) {
            return this.runGlobalTaskTimerFolia(runnable, delay, interval);
        }
        return new TaskWrapper(Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, runnable, delay, interval));
    }

    @NotNull
    public TaskWrapper runGlobalTaskTimerAsync(@NotNull Runnable runnable, long delay, long interval) {
        if (AnnoyingPlugin.FOLIA) {
            return this.runGlobalTaskTimerFolia(runnable, delay, interval);
        }
        return new TaskWrapper(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, runnable, delay, interval));
    }

    @NotNull
    private TaskWrapper runGlobalTaskTimerFolia(@NotNull Runnable runnable, long delay, long interval) {
        try {
            Object scheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            return new TaskWrapper(scheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE).invoke(scheduler, new Object[]{this.plugin, new FoliaConsumer(runnable), delay, interval}));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to run a Folia task!", e);
        }
    }

    private static class FoliaConsumer
    implements Consumer<Object> {
        @NotNull
        private final Runnable runnable;

        public FoliaConsumer(@NotNull Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void accept(@NotNull Object object) {
            this.runnable.run();
        }
    }
}

