/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.libs.javautilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class FileUtility {
    public static boolean deleteFile(@NotNull Path path, boolean silentFail) {
        try {
            Files.delete(path);
            return true;
        }
        catch (IOException e) {
            if (!silentFail) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @NotNull
    public static Set<String> getFileNames(@NotNull File file, @NotNull String extension) {
        File[] files = file.listFiles();
        if (files == null) {
            return Collections.emptySet();
        }
        String fullExtension = "." + extension;
        int extensionLength = fullExtension.length();
        return Arrays.stream(files).map(File::getName).filter(name -> name.endsWith(fullExtension)).map(name -> name.substring(0, name.length() - extensionLength)).collect(Collectors.toSet());
    }

    @NotNull
    public static List<String> getResourceContent(@NotNull String fileName) {
        ArrayList<String> arrayList;
        block18: {
            InputStream inputStream = FileUtility.class.getResourceAsStream(fileName);
            try {
                if (inputStream == null) {
                    throw new NullPointerException("Failed to get resource: " + fileName);
                }
                ArrayList<String> content = new ArrayList<String>();
                try (Scanner scanner = new Scanner(inputStream);){
                    while (scanner.hasNextLine()) {
                        content.add(scanner.nextLine());
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                arrayList = content;
                if (inputStream == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read resource: " + fileName, e);
                }
            }
            inputStream.close();
        }
        return arrayList;
    }

    public static void copyResourceFolder(@NotNull String resourcePath, @NotNull Path destinationDirectory) throws IOException {
        URI uri;
        URL resource = FileUtility.class.getResource(resourcePath);
        if (resource == null) {
            throw new FileNotFoundException("Resource not found: " + resourcePath);
        }
        try {
            uri = resource.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI for resource: " + resourcePath, e);
        }
        if (!Files.exists(destinationDirectory, new LinkOption[0])) {
            Files.createDirectories(destinationDirectory, new FileAttribute[0]);
        }
        if (uri.getScheme().equals("jar")) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(uri, new HashMap());){
                FileUtility.walkAndCopy(fileSystem.getPath(resourcePath, new String[0]), destinationDirectory);
            }
            return;
        }
        FileUtility.walkAndCopy(Paths.get(uri), destinationDirectory);
    }

    public static void walkAndCopy(@NotNull Path source, @NotNull Path destination) throws IOException {
        try (Stream<Path> files = Files.walk(source, new FileVisitOption[0]);){
            files.forEach(path -> {
                try {
                    Path fileDestination = destination.resolve(source.relativize((Path)path).toString());
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        Files.createDirectories(fileDestination, new FileAttribute[0]);
                        return;
                    }
                    Files.createDirectories(fileDestination.getParent(), new FileAttribute[0]);
                    Files.copy(path, fileDestination, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private FileUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

