/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.data;

import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.personalphantoms.libs.annoyingapi.data.Data;
import xyz.srnyx.personalphantoms.libs.annoyingapi.storage.FailedSet;
import xyz.srnyx.personalphantoms.libs.annoyingapi.storage.Value;

public class StringData
extends Data<String> {
    @NotNull
    public static final String TARGET_COLUMN = "target";
    @NotNull
    private final String table;
    public boolean useCache;

    public StringData(@NotNull AnnoyingPlugin plugin, @NotNull String table, @NotNull String string) {
        super(plugin, string);
        if (plugin.dataManager == null) {
            throw new IllegalStateException(plugin.options.dataOptions.enabled ? "Data manager is not initialized!" : "Data manager is not enabled! Plugin devs: enable it by setting options.dataOptions.enabled to true");
        }
        this.table = plugin.dataManager.getTableName(table);
        this.useCache(null);
    }

    public StringData(@NotNull AnnoyingPlugin plugin, @NotNull OfflinePlayer player) {
        this(plugin, "entities", player.getUniqueId().toString());
    }

    @NotNull
    public StringData useCache(@Nullable Boolean useCache) {
        this.useCache = this.plugin.dataManager != null && this.plugin.dataManager.storageConfig.cache.enabled && (useCache == null ? this.plugin.options.dataOptions.useCacheDefault : useCache != false);
        return this;
    }

    @Override
    @Nullable
    public String get(@NotNull String key) {
        Value cached;
        if (this.plugin.dataManager == null) {
            AnnoyingPlugin.log(Level.SEVERE, "&cFailed to get &4" + key + "&c for &4" + (String)this.target + "&c in &4" + this.table + "&c. DEVELOPERS: Make sure you added the table/column to DataOptions!");
            return null;
        }
        if (this.useCache && (cached = this.plugin.dataManager.dialect.getFromCache(this.table, (String)this.target, key)) != null) {
            return cached.value;
        }
        String data = this.plugin.dataManager.dialect.getFromDatabase(this.table, (String)this.target, key).orElse(null);
        if (this.useCache) {
            this.plugin.dataManager.dialect.setToCache(this.table, (String)this.target, key, new Value(data));
        }
        return data;
    }

    @Override
    protected boolean set(@NotNull String key, @NotNull String value) {
        if (this.plugin.dataManager == null) {
            AnnoyingPlugin.log(Level.SEVERE, "&cFailed to set &4" + key + "&c for &4" + (String)this.target + "&c in &4" + this.table + "&c. DEVELOPERS: Make sure you added the table/column to DataOptions!");
            return false;
        }
        if (this.useCache) {
            this.plugin.dataManager.dialect.setToCache(this.table, (String)this.target, key, new Value(value));
            return true;
        }
        FailedSet failed = this.plugin.dataManager.dialect.setToDatabase(this.table, (String)this.target, key, value);
        if (failed != null) {
            AnnoyingPlugin.log(Level.SEVERE, "&cFailed to set &4" + key + "&c for &4" + (String)this.target + "&c in &4" + this.table + "&c. DEVELOPERS: Make sure you added the table/column to DataOptions!", failed.exception);
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(@NotNull String key) {
        if (this.plugin.dataManager == null) {
            AnnoyingPlugin.log(Level.SEVERE, "&cFailed to remove &4" + key + "&c for &4" + (String)this.target + "&c in &4" + this.table + "&c. DEVELOPERS: Make sure you added the table/column to DataOptions!");
            return false;
        }
        if (this.useCache) {
            this.plugin.dataManager.dialect.markRemovedInCache(this.table, (String)this.target, key);
            return true;
        }
        if (!this.plugin.dataManager.dialect.removeValueFromDatabase(this.table, (String)this.target, key)) {
            AnnoyingPlugin.log(Level.SEVERE, "&cFailed to remove &4" + key + "&c for &4" + (String)this.target + "&c in &4" + this.table + "&c. DEVELOPERS: Make sure you added the table/column to DataOptions!");
            return false;
        }
        return true;
    }
}

