/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.personalphantoms.PersonalPhantoms;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.personalphantoms.libs.annoyingapi.command.AnnoyingCommand;
import xyz.srnyx.personalphantoms.libs.annoyingapi.command.AnnoyingSender;
import xyz.srnyx.personalphantoms.libs.annoyingapi.command.selector.Selector;
import xyz.srnyx.personalphantoms.libs.annoyingapi.cooldown.AnnoyingCooldown;
import xyz.srnyx.personalphantoms.libs.annoyingapi.data.StringData;
import xyz.srnyx.personalphantoms.libs.annoyingapi.message.AnnoyingMessage;
import xyz.srnyx.personalphantoms.libs.annoyingapi.message.DefaultReplaceType;
import xyz.srnyx.personalphantoms.libs.annoyingapi.utility.BukkitUtility;

public class NoPhantomsCmd
extends AnnoyingCommand {
    @NotNull
    private final PersonalPhantoms plugin;

    public NoPhantomsCmd(@NotNull PersonalPhantoms plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public PersonalPhantoms getAnnoyingPlugin() {
        return this.plugin;
    }

    @Override
    public String getPermission() {
        return "pp.nophantoms";
    }

    @Override
    public void onCommand(@NotNull AnnoyingSender sender) {
        boolean inverse;
        CommandSender cmdSender = sender.cmdSender;
        int length = sender.args.length;
        if (sender.argEquals(0, "reload")) {
            if (!sender.checkPermission("pp.reload")) {
                return;
            }
            this.plugin.reloadPlugin();
            new AnnoyingMessage(this.plugin, "reload").send(sender);
            return;
        }
        boolean bl = inverse = sender.label != null && sender.label.equalsIgnoreCase("nophantoms");
        if (length == 1) {
            if (sender.argEquals(0, "get")) {
                if (sender.checkPlayer()) {
                    new AnnoyingMessage(this.plugin, "get.self").replace("%status%", !this.plugin.hasPhantomsEnabled((OfflinePlayer)sender.getPlayer()), DefaultReplaceType.BOOLEAN).send(sender);
                }
                return;
            }
            if (sender.argEquals(0, "toggle", "enable", "disable")) {
                long duration;
                AnnoyingCooldown cooldown;
                if (!sender.checkPlayer()) {
                    return;
                }
                Player player = sender.getPlayer();
                if (!cmdSender.hasPermission("pp.nophantoms.bypass") && (cooldown = this.plugin.cooldownManager.getCooldownElseNew("NoPhantomsCmd", player.getUniqueId().toString())).isOnCooldownStart(duration = BukkitUtility.getPermissionValue(player, "pp.nophantoms.cooldown.").map(value -> value * 1000L).orElse(this.plugin.config.commandCooldown).longValue())) {
                    new AnnoyingMessage(this.plugin, "nophantoms.cooldown").replace("%cooldown%", cooldown.getRemaining(), DefaultReplaceType.TIME).send(sender);
                    return;
                }
                boolean newStatus = this.editKey((OfflinePlayer)player, sender.argEquals(0, "toggle") ? null : Boolean.valueOf(sender.argEquals(0, "enable") ^ inverse));
                new AnnoyingMessage(this.plugin, "nophantoms.self").replace("%status%", newStatus, DefaultReplaceType.BOOLEAN).send(sender);
                return;
            }
            sender.invalidArguments();
            return;
        }
        if (length != 2) {
            sender.invalidArguments();
            return;
        }
        if (!sender.checkPermission("pp.nophantoms.others")) {
            return;
        }
        List<OfflinePlayer> targets = sender.getSelector(1, OfflinePlayer.class).orElseFlatSingle(BukkitUtility::getOfflinePlayer);
        if (targets == null) {
            return;
        }
        if (sender.argEquals(0, "get")) {
            for (OfflinePlayer target : targets) {
                new AnnoyingMessage(this.plugin, "get.other").replace("%target%", target.getName()).replace("%status%", !this.plugin.hasPhantomsEnabled(target), DefaultReplaceType.BOOLEAN).send(sender);
            }
            return;
        }
        if (sender.argEquals(0, "toggle", "enable", "disable")) {
            for (OfflinePlayer target : targets) {
                boolean newStatus = this.editKey(target, sender.argEquals(0, "toggle") ? null : Boolean.valueOf(sender.argEquals(0, "enable") ^ inverse));
                new AnnoyingMessage(this.plugin, "nophantoms.toggler").replace("%target%", target.getName()).replace("%status%", newStatus, DefaultReplaceType.BOOLEAN).send(sender);
                Player targetOnline = target.getPlayer();
                if (targetOnline == null) continue;
                new AnnoyingMessage(this.plugin, "nophantoms.other").replace("%status%", newStatus, DefaultReplaceType.BOOLEAN).replace("%toggler%", cmdSender.getName()).send((CommandSender)targetOnline);
            }
            return;
        }
        sender.invalidArguments();
    }

    @Override
    @Nullable
    public Collection<String> onTabComplete(@NotNull AnnoyingSender sender) {
        CommandSender cmdSender = sender.cmdSender;
        if (sender.args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            if (cmdSender.hasPermission("pp.reload")) {
                list.add("reload");
            }
            if (cmdSender.hasPermission("pp.nophantoms")) {
                list.add("get");
                list.add("toggle");
                list.add("enable");
                list.add("disable");
            }
            return list;
        }
        if (!sender.argEquals(0, "reload") && cmdSender.hasPermission("pp.nophantoms.others")) {
            return Selector.addKeys(BukkitUtility.getOnlinePlayerNames(), OfflinePlayer.class);
        }
        return null;
    }

    private boolean editKey(@NotNull OfflinePlayer offline, @Nullable Boolean enablePhantoms) {
        StringData data = new StringData((AnnoyingPlugin)this.plugin, offline);
        if (enablePhantoms == null) {
            enablePhantoms = !this.plugin.hasPhantomsEnabled(data);
        }
        data.set("pp_no-phantoms", enablePhantoms == false);
        Player online = offline.getPlayer();
        if (online != null && this.plugin.isWhitelistedWorld(online.getWorld())) {
            if (enablePhantoms.booleanValue()) {
                online.setStatistic(Statistic.TIME_SINCE_REST, 72000);
            } else {
                PersonalPhantoms.resetStatistic(online);
            }
        }
        return enablePhantoms;
    }
}

