/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms;

import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.personalphantoms.ConfigYml;
import xyz.srnyx.personalphantoms.PersonalPlaceholders;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.personalphantoms.libs.annoyingapi.PluginPlatform;
import xyz.srnyx.personalphantoms.libs.annoyingapi.data.StringData;
import xyz.srnyx.personalphantoms.libs.annoyingapi.options.BStatsOptions;
import xyz.srnyx.personalphantoms.libs.annoyingapi.options.DataOptions;
import xyz.srnyx.personalphantoms.libs.annoyingapi.options.PluginOptions;
import xyz.srnyx.personalphantoms.libs.annoyingapi.scheduler.TaskWrapper;

public class PersonalPhantoms
extends AnnoyingPlugin {
    @NotNull
    public static final String KEY = "pp_no-phantoms";
    public ConfigYml config;
    @NotNull
    private final Map<String, TaskWrapper> tasks = new HashMap<String, TaskWrapper>();

    public PersonalPhantoms() {
        this.options.pluginOptions((Consumer<PluginOptions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$new$0(xyz.srnyx.personalphantoms.libs.annoyingapi.options.PluginOptions ), (Lxyz/srnyx/personalphantoms/libs/annoyingapi/options/PluginOptions;)V)((PersonalPhantoms)this)).bStatsOptions((Consumer<BStatsOptions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$new$1(xyz.srnyx.personalphantoms.libs.annoyingapi.options.BStatsOptions ), (Lxyz/srnyx/personalphantoms/libs/annoyingapi/options/BStatsOptions;)V)()).dataOptions((Consumer<DataOptions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$new$2(xyz.srnyx.personalphantoms.libs.annoyingapi.options.DataOptions ), (Lxyz/srnyx/personalphantoms/libs/annoyingapi/options/DataOptions;)V)()).registrationOptions.automaticRegistration(automaticRegistration -> automaticRegistration.packages("xyz.srnyx.personalphantoms.commands", "xyz.srnyx.personalphantoms.listeners")).papiExpansionToRegister(() -> new PersonalPlaceholders(this));
    }

    @Override
    public void enable() {
        this.reload();
    }

    @Override
    public void reload() {
        this.config = new ConfigYml(this);
        Long delay = this.config.statisticTask.delay;
        long period = this.config.statisticTask.period;
        for (World world : Bukkit.getWorlds()) {
            Long worldDelay;
            long time;
            boolean isNight;
            String name = world.getName();
            if (!this.isWhitelistedWorld(world)) continue;
            TaskWrapper previousTask = this.tasks.get(name);
            if (previousTask != null) {
                previousTask.cancel();
            }
            boolean bl = isNight = (time = world.getTime()) >= 12000L;
            if (isNight) {
                this.resetAllStatistics(world);
            }
            if ((worldDelay = delay) == null) {
                worldDelay = isNight ? 36000L - time : 12000L - time;
            }
            this.tasks.put(name, this.scheduler.runGlobalTaskTimer(() -> this.resetAllStatistics(world), worldDelay, period));
        }
    }

    public boolean hasPhantomsEnabled(@NotNull StringData data) {
        return data.getOptional(KEY).map(value -> !value.equals("true")).orElse(this.config.def);
    }

    public boolean hasPhantomsEnabled(@NotNull OfflinePlayer player) {
        return this.hasPhantomsEnabled(new StringData((AnnoyingPlugin)this, player));
    }

    private void resetAllStatistics(@NotNull World world) {
        for (Player player : world.getPlayers()) {
            if (this.hasPhantomsEnabled((OfflinePlayer)player)) continue;
            PersonalPhantoms.resetStatistic(player);
        }
    }

    public boolean isWhitelistedWorld(@NotNull World world) {
        return this.config.worldsBlacklist.list == null || this.config.worldsBlacklist.list.contains(world.getName()) == this.config.worldsBlacklist.treatAsWhitelist;
    }

    public static void resetStatistic(@NotNull Player player) {
        player.setStatistic(Statistic.TIME_SINCE_REST, 0);
    }

    private static /* synthetic */ void lambda$new$2(DataOptions dataOptions) {
        dataOptions.enabled(true).entityDataColumns(KEY);
    }

    private static /* synthetic */ void lambda$new$1(BStatsOptions bStatsOptions) {
        bStatsOptions.id(18328);
    }

    private /* synthetic */ void lambda$new$0(PluginOptions pluginOptions) {
        pluginOptions.updatePlatforms(PluginPlatform.modrinth("lzjYdd5h"), PluginPlatform.hangar((Plugin)this), PluginPlatform.spigot("106381"));
    }
}

