/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.storage.dialects;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.storage.DataManager;
import xyz.srnyx.personalphantoms.libs.annoyingapi.storage.FailedSet;
import xyz.srnyx.personalphantoms.libs.annoyingapi.storage.Value;

public abstract class Dialect {
    @NotNull
    protected final DataManager dataManager;

    public Dialect(@NotNull DataManager dataManager) {
        this.dataManager = dataManager;
    }

    @Nullable
    public Value getFromCache(@NotNull String table, @NotNull String target, @NotNull String key) {
        return this.getFromCacheImpl(table, target, key);
    }

    public void setToCache(@NotNull String table, @NotNull String target, @NotNull String key, @Nullable Value value) {
        if (value == null) {
            this.markRemovedInCache(table, target, key);
            return;
        }
        this.setToCacheImpl(table, target, key, value);
    }

    public void markRemovedInCache(@NotNull String table, @NotNull String target, @NotNull String key) {
        this.markRemovedInCacheImpl(table, target, key);
    }

    public void saveCache() {
        this.saveCacheImpl();
    }

    public void saveCache(@NotNull String table, @NotNull String target) {
        this.saveCacheImpl(table, target);
    }

    @NotNull
    public final Optional<MigrationData> getMigrationDataFromDatabase(@NotNull DataManager newManager) {
        return this.getMigrationDataFromDatabaseImpl(newManager);
    }

    @NotNull
    public final Optional<String> getFromDatabase(@NotNull String table, @NotNull String target, @NotNull String key) {
        return this.getFromDatabaseImpl(table, target, key.toLowerCase());
    }

    @Nullable
    public final FailedSet setToDatabase(@NotNull String table, @NotNull String target, @NotNull String key, @NotNull String value) {
        return this.setToDatabaseImpl(table, target, key.toLowerCase(), value);
    }

    @NotNull
    public final Set<FailedSet> setToDatabase(@NotNull String table, @NotNull String target, @NotNull ConcurrentHashMap<String, Value> data) {
        ConcurrentHashMap<String, Value> dataLower = new ConcurrentHashMap<String, Value>();
        for (Map.Entry<String, Value> entry : data.entrySet()) {
            dataLower.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return this.setToDatabaseImpl(table, target, dataLower);
    }

    @NotNull
    public final Set<FailedSet> setToDatabase(@NotNull ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>> data) {
        HashSet<FailedSet> failed = new HashSet<FailedSet>();
        for (Map.Entry<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>> entry : data.entrySet()) {
            String table = entry.getKey();
            for (Map.Entry<String, ConcurrentHashMap<String, Value>> entry1 : entry.getValue().entrySet()) {
                Set<FailedSet> failedSet = this.setToDatabase(table, entry1.getKey(), entry1.getValue());
                if (failedSet.isEmpty()) continue;
                failed.addAll(failedSet);
            }
        }
        return failed;
    }

    public final boolean removeValueFromDatabase(@NotNull String table, @NotNull String target, @NotNull String key) {
        return this.removeFromDatabaseImpl(table, target, key.toLowerCase());
    }

    @Nullable
    protected abstract Value getFromCacheImpl(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    protected abstract void setToCacheImpl(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull Value var4);

    protected abstract void markRemovedInCacheImpl(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    protected abstract void saveCacheImpl();

    protected abstract void saveCacheImpl(@NotNull String var1, @NotNull String var2);

    @NotNull
    protected abstract Optional<MigrationData> getMigrationDataFromDatabaseImpl(@NotNull DataManager var1);

    @NotNull
    protected abstract Optional<String> getFromDatabaseImpl(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    @Nullable
    protected abstract FailedSet setToDatabaseImpl(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    @NotNull
    protected abstract Set<FailedSet> setToDatabaseImpl(@NotNull String var1, @NotNull String var2, @NotNull ConcurrentHashMap<String, Value> var3);

    protected abstract boolean removeFromDatabaseImpl(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public static class MigrationData {
        @NotNull
        public final Map<String, Set<String>> tablesKeys;
        @NotNull
        public final ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>> data;

        public MigrationData(@NotNull Map<String, Set<String>> tablesKeys, @NotNull ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>> data) {
            this.tablesKeys = tablesKeys;
            this.data = data;
        }
    }
}

