/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.data;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.personalphantoms.libs.annoyingapi.data.StringData;
import xyz.srnyx.personalphantoms.libs.annoyingapi.file.AnnoyingData;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.RefNamespacedKey;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.persistence.RefPersistentDataContainer;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.persistence.RefPersistentDataHolder;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.persistence.RefPersistentDataType;

public class EntityData
extends StringData {
    @NotNull
    public static final String TABLE_NAME = "entities";
    @NotNull
    private static final String CONVERTED_KEY = "annoyingapi_converted";
    @NotNull
    private final Entity entity;

    public EntityData(@NotNull AnnoyingPlugin plugin, @NotNull Entity entity) {
        super(plugin, TABLE_NAME, entity.getUniqueId().toString());
        this.entity = entity;
    }

    @Nullable
    public Map<String, String> convertOldData(boolean onlyTryOnce, @Nullable Collection<String> keys) {
        if (RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR != null && RefPersistentDataHolder.PERSISTENT_DATA_HOLDER_GET_PERSISTENT_DATA_CONTAINER_METHOD != null && RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_GET_METHOD != null && RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_SET_METHOD != null && RefPersistentDataType.PERSISTENT_DATA_TYPE_STRING != null && RefPersistentDataType.PERSISTENT_DATA_TYPE_BYTE != null) {
            Object convertedKey;
            Object persistentDataContainer;
            try {
                persistentDataContainer = RefPersistentDataHolder.PERSISTENT_DATA_HOLDER_GET_PERSISTENT_DATA_CONTAINER_METHOD.invoke((Object)this.entity, new Object[0]);
                convertedKey = RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, CONVERTED_KEY});
                if (RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_GET_METHOD.invoke(persistentDataContainer, convertedKey, RefPersistentDataType.PERSISTENT_DATA_TYPE_BYTE) != null) {
                    return Collections.emptyMap();
                }
                if (onlyTryOnce) {
                    RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_SET_METHOD.invoke(persistentDataContainer, convertedKey, RefPersistentDataType.PERSISTENT_DATA_TYPE_BYTE, (byte)1);
                }
            }
            catch (ReflectiveOperationException e) {
                this.sendError("convert", e);
                return null;
            }
            HashMap<String, Object> namespacedKeys = new HashMap<String, Object>();
            if (RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_GET_KEYS_METHOD != null && RefNamespacedKey.NAMESPACED_KEY_GET_NAMESPACE_METHOD != null && RefNamespacedKey.NAMESPACED_KEY_GET_KEY_METHOD != null) {
                String pluginName = this.plugin.getName().toLowerCase();
                try {
                    for (Object e : (Set)RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_GET_KEYS_METHOD.invoke(persistentDataContainer, new Object[0])) {
                        String key;
                        String namespace = (String)RefNamespacedKey.NAMESPACED_KEY_GET_NAMESPACE_METHOD.invoke(e, new Object[0]);
                        if (!pluginName.equals(namespace.toLowerCase()) || (key = (String)RefNamespacedKey.NAMESPACED_KEY_GET_KEY_METHOD.invoke(e, new Object[0])).equals(CONVERTED_KEY)) continue;
                        namespacedKeys.put(key, e);
                    }
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    this.sendError("convert", reflectiveOperationException);
                    return null;
                }
            }
            if (keys == null || keys.isEmpty()) {
                return Collections.emptyMap();
            }
            try {
                for (String string : keys) {
                    Object obj = RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, string});
                    namespacedKeys.put(string, obj);
                }
            }
            catch (ReflectiveOperationException e) {
                this.sendError("convert", e);
                return null;
            }
            try {
                HashMap<String, String> failed = new HashMap<String, String>();
                for (Map.Entry entry : namespacedKeys.entrySet()) {
                    String value;
                    String key = (String)entry.getKey();
                    Object namespacedKey = entry.getValue();
                    try {
                        value = (String)RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_GET_METHOD.invoke(persistentDataContainer, namespacedKey, RefPersistentDataType.PERSISTENT_DATA_TYPE_STRING);
                    }
                    catch (InvocationTargetException e) {
                        failed.put(key, null);
                        continue;
                    }
                    if (value == null || this.set(key, value)) continue;
                    failed.put(key, value);
                }
                if (!onlyTryOnce && failed.isEmpty()) {
                    RefPersistentDataContainer.PERSISTENT_DATA_CONTAINER_SET_METHOD.invoke(persistentDataContainer, convertedKey, RefPersistentDataType.PERSISTENT_DATA_TYPE_BYTE, (byte)1);
                }
                return failed;
            }
            catch (ReflectiveOperationException e) {
                this.sendError("convert", e);
                return null;
            }
        }
        AnnoyingData file = new AnnoyingData(this.plugin, this.plugin.options.dataOptions.entities.path + "/" + (String)this.target + ".yml", this.plugin.options.dataOptions.entities.fileOptions);
        ConfigurationSection section = file.getConfigurationSection(this.plugin.options.dataOptions.entities.section);
        if (section == null || section.getBoolean("annoyingapi.converted")) {
            return Collections.emptyMap();
        }
        HashMap<String, String> failed = new HashMap<String, String>();
        for (String string : section.getKeys(false)) {
            String string2 = section.getString(string);
            if (string2 == null || this.set(string, string2)) continue;
            failed.put(string, string2);
        }
        if (failed.isEmpty() || onlyTryOnce) {
            section.set("annoyingapi.converted", (Object)true);
            file.save();
        }
        return failed;
    }

    @Nullable
    public Map<String, String> convertOldData(boolean onlyTryOnce, String ... keys) {
        return this.convertOldData(onlyTryOnce, Arrays.asList(keys));
    }

    @Nullable
    public Map<String, String> convertOldData(@NotNull Collection<String> keys) {
        return this.convertOldData(false, keys);
    }

    @Nullable
    public Map<String, String> convertOldData(String ... keys) {
        return this.convertOldData(false, keys);
    }

    @Nullable
    public Map<String, String> convertOldData(boolean onlyTryOnce) {
        return this.convertOldData(onlyTryOnce, (Collection<String>)null);
    }

    @Nullable
    public Map<String, String> convertOldData() {
        return this.convertOldData(false, (Collection<String>)null);
    }
}

