/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.command;

import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.personalphantoms.libs.annoyingapi.command.selector.SelectorOptional;
import xyz.srnyx.personalphantoms.libs.annoyingapi.libs.javautilities.objects.Arguments;
import xyz.srnyx.personalphantoms.libs.annoyingapi.message.AnnoyingMessage;
import xyz.srnyx.personalphantoms.libs.annoyingapi.parents.Annoyable;

public class AnnoyingSender
extends Arguments
implements Annoyable {
    @NotNull
    public final AnnoyingPlugin plugin;
    @NotNull
    public final CommandSender cmdSender;
    @Nullable
    public final Command command;
    @Nullable
    public final String label;
    public final boolean isPlayer;

    public AnnoyingSender(@NotNull AnnoyingPlugin plugin, @NotNull CommandSender cmdSender, @Nullable Command command, @Nullable String label, @Nullable String[] args) {
        super(args);
        this.plugin = plugin;
        this.cmdSender = cmdSender;
        this.command = command;
        this.label = label;
        this.isPlayer = cmdSender instanceof Player;
    }

    public AnnoyingSender(@NotNull AnnoyingPlugin plugin, @NotNull CommandSender cmdSender) {
        this(plugin, cmdSender, null, null, null);
    }

    @Override
    @NotNull
    public AnnoyingPlugin getAnnoyingPlugin() {
        return this.plugin;
    }

    @NotNull
    public String getFullCommand() {
        StringBuilder command = new StringBuilder();
        if (this.label != null) {
            command.append(this.label);
        }
        if (this.args != null && this.args.length != 0) {
            command.append(" ").append(this.getArgumentsJoined());
        }
        return command.toString();
    }

    public boolean equalsSender(@NotNull CommandSender sender) {
        return this.cmdSender.equals((Object)sender);
    }

    public boolean checkPlayer() {
        if (!this.isPlayer) {
            new AnnoyingMessage(this.plugin, this.plugin.options.messagesOptions.keys.playerOnly).send(this);
        }
        return this.isPlayer;
    }

    public boolean checkPermission(@NotNull String permission) {
        boolean hasPermission = this.cmdSender.hasPermission(permission);
        if (!hasPermission) {
            new AnnoyingMessage(this.plugin, this.plugin.options.messagesOptions.keys.noPermission).replace("%permission%", permission).send(this);
        }
        return hasPermission;
    }

    @NotNull
    public Player getPlayer() {
        if (!this.isPlayer) {
            throw new IllegalStateException("CommandSender is not a Player");
        }
        return (Player)this.cmdSender;
    }

    @Nullable
    public Player getPlayerOrNull() {
        return this.isPlayer ? (Player)this.cmdSender : null;
    }

    @NotNull
    public Optional<Player> getPlayerOptional() {
        return Optional.ofNullable(this.getPlayerOrNull());
    }

    @Nullable
    public <T> T getArgument(int index, @NotNull Function<String, T> function) {
        String argument = this.getArgument(index);
        if (argument == null) {
            this.invalidArgumentByIndex(index);
            return null;
        }
        T value = function.apply(argument);
        if (value == null) {
            this.invalidArgument(argument);
        }
        return value;
    }

    @NotNull
    public <T> Optional<T> getArgumentOptional(int index, @NotNull Function<String, T> function) {
        Optional<T> optional = this.getArgumentOptional(index).map(function);
        if (!optional.isPresent()) {
            this.invalidArgumentByIndex(index);
        }
        return optional;
    }

    @NotNull
    public <T> Optional<T> getArgumentOptionalFlat(int index, @NotNull Function<String, Optional<T>> function) {
        Optional<T> optional = this.getArgumentOptional(index).flatMap(function);
        if (!optional.isPresent()) {
            this.invalidArgumentByIndex(index);
        }
        return optional;
    }

    @NotNull
    public <T> SelectorOptional<T> getSelector(int index, @NotNull Class<T> type) {
        String argument = this.getArgument(index);
        if (argument == null) {
            this.invalidArguments();
            return SelectorOptional.noArgument(this);
        }
        SelectorOptional<T> selector = SelectorOptional.of(this, argument, type);
        if (selector.isEmpty()) {
            this.invalidArgument(argument);
        }
        return selector;
    }

    public void invalidArgument(@Nullable Object argument) {
        new AnnoyingMessage(this.plugin, this.plugin.options.messagesOptions.keys.invalidArgument).replace("%argument%", String.valueOf(argument)).send(this);
    }

    public void invalidArgumentByIndex(int index) {
        boolean invalid;
        boolean bl = invalid = this.args == null || this.args.length <= index;
        if (invalid) {
            AnnoyingPlugin.log(Level.WARNING, "&4[" + this.label + "]&c Invalid argument index for invalidArgumentByIndex: &4" + index);
        }
        this.invalidArgument(invalid ? Integer.valueOf(index) : this.args[index]);
    }

    public void invalidArguments() {
        new AnnoyingMessage(this.plugin, this.plugin.options.messagesOptions.keys.invalidArguments).send(this);
    }
}

