/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.personalphantoms.libs.annoyingapi.file.AnnoyingResource;

public class ConfigYml {
    @NotNull
    private final AnnoyingResource config;
    public final boolean def;
    public final long commandCooldown;
    @NotNull
    public StatisticTask statisticTask;
    @NotNull
    public WorldsBlacklist worldsBlacklist;

    public ConfigYml(@NotNull AnnoyingPlugin plugin) {
        this.config = new AnnoyingResource(plugin, "config.yml");
        this.def = this.config.getBoolean("default", true);
        this.commandCooldown = this.config.getLong("command-cooldown", 600L) * 1000L;
        this.statisticTask = new StatisticTask();
        this.worldsBlacklist = new WorldsBlacklist();
    }

    public class StatisticTask {
        @Nullable
        public final Long delay;
        public final long period;

        public StatisticTask() {
            this.delay = ConfigYml.this.config.getString("statistic-task.delay", "automatic").equals("automatic") ? null : Long.valueOf(ConfigYml.this.config.getLong("statistic-task.delay"));
            this.period = ConfigYml.this.config.getLong("statistic-task.period", 24000L);
        }
    }

    public class WorldsBlacklist {
        @Nullable
        public final Set<String> list;
        public final boolean treatAsWhitelist;

        public WorldsBlacklist() {
            this.treatAsWhitelist = ConfigYml.this.config.getBoolean("worlds-blacklist.treat-as-whitelist");
            List stringList = ConfigYml.this.config.getStringList("worlds-blacklist.list");
            this.list = stringList.isEmpty() && !this.treatAsWhitelist ? null : new HashSet<String>(stringList);
        }
    }
}

