/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.jetbrains.annotations.NotNull;

public class ConfigurationUtility {
    @NotNull
    public static MemoryConfiguration toConfiguration(@NotNull Map<?, ?> map) {
        MemoryConfiguration configuration = new MemoryConfiguration();
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                configuration.set(key.toString(), (Object)ConfigurationUtility.toConfiguration((Map)value));
                return;
            }
            configuration.set(key.toString(), value);
        });
        return configuration;
    }

    @NotNull
    public static List<MemoryConfiguration> toConfigurationList(@NotNull List<Map<?, ?>> maps) {
        ArrayList<MemoryConfiguration> configurations = new ArrayList<MemoryConfiguration>();
        maps.forEach(map -> configurations.add(ConfigurationUtility.toConfiguration(map)));
        return configurations;
    }

    @NotNull
    public static Map<String, Object> toMap(@NotNull ConfigurationSection section) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        section.getKeys(false).forEach(key -> {
            Object value = section.get(key);
            if (value instanceof ConfigurationSection) {
                map.put((String)key, ConfigurationUtility.toMap((ConfigurationSection)value));
                return;
            }
            map.put((String)key, value);
        });
        return map;
    }

    @NotNull
    public static List<Map<String, Object>> toMapList(@NotNull List<ConfigurationSection> sections) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        sections.forEach(section -> maps.add(ConfigurationUtility.toMap(section)));
        return maps;
    }

    private ConfigurationUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

