/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.storage.dialects;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.libs.annoyingapi.file.AnnoyingData;
import xyz.srnyx.manymobs.libs.annoyingapi.file.AnnoyingFile;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.FileUtility;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.DataManager;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.FailedSet;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.Value;
import xyz.srnyx.manymobs.libs.annoyingapi.storage.dialects.Dialect;

public class YAMLDialect
extends Dialect {
    @NotNull
    private final Map<String, AnnoyingData> tables = new HashMap<String, AnnoyingData>();

    public YAMLDialect(@NotNull DataManager dataManager) {
        super(dataManager);
    }

    @NotNull
    private Optional<AnnoyingData> getTableFromCache(@NotNull String table) {
        return Optional.ofNullable(this.tables.get(table));
    }

    @Override
    @Nullable
    public Value getFromCacheImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        return this.getTableFromCache(table).map(file -> new Value(file.getString(target + "." + key))).orElse(null);
    }

    @Override
    public void setToCacheImpl(@NotNull String table, @NotNull String target, @NotNull String key, @NotNull Value value) {
        this.getTableFromCache(table).orElseGet(() -> {
            AnnoyingData file = this.getTableFromDatabase(table);
            this.tables.put(table, file);
            return file;
        }).set(target + "." + key, value.value);
    }

    @Override
    public void markRemovedInCacheImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        this.getTableFromCache(table).ifPresent(file -> file.set(target + "." + key, null));
    }

    @Override
    public void saveCacheImpl() {
        for (AnnoyingData file : this.tables.values()) {
            file.save();
        }
    }

    @Override
    public void saveCacheImpl(@NotNull String table, @NotNull String target) {
        this.getTableFromCache(table).ifPresent(AnnoyingFile::save);
    }

    @NotNull
    private AnnoyingData getTableFromDatabase(@NotNull String table) {
        return new AnnoyingData(this.dataManager.plugin, "yaml/" + table + ".yaml");
    }

    @Override
    @NotNull
    protected Optional<Dialect.MigrationData> getMigrationDataFromDatabaseImpl(@NotNull DataManager newManager) {
        HashMap<String, Set<String>> tablesKeys = new HashMap<String, Set<String>>();
        ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>> data = new ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>>();
        for (String table : FileUtility.getFileNames(new File(this.dataManager.plugin.getDataFolder(), "data/yaml"), "yaml")) {
            AnnoyingData file = this.getTableFromDatabase(table);
            HashSet<String> keys = new HashSet<String>();
            ConcurrentHashMap tableData = new ConcurrentHashMap();
            for (String target : file.getKeys(false)) {
                ConfigurationSection targetData = file.getConfigurationSection(target);
                if (targetData == null) continue;
                ConcurrentHashMap<String, Value> targetMap = new ConcurrentHashMap<String, Value>();
                for (String key : targetData.getKeys(false)) {
                    keys.add(key);
                    targetMap.put(key, new Value(targetData.getString(key)));
                }
                tableData.put(target, targetMap);
            }
            tablesKeys.put(table, keys);
            data.put(table, tableData);
        }
        return Optional.of(new Dialect.MigrationData(tablesKeys, data));
    }

    @Override
    @NotNull
    protected Optional<String> getFromDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        return Optional.ofNullable(this.getTableFromDatabase(table).getString(target + "." + key));
    }

    @Override
    @Nullable
    protected FailedSet setToDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull String key, @NotNull String value) {
        return this.getTableFromDatabase(table).setSave(target + "." + key, value) ? null : new FailedSet(table, target, key, value);
    }

    @Override
    @NotNull
    protected Set<FailedSet> setToDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull ConcurrentHashMap<String, Value> data) {
        Set<Map.Entry<String, Value>> entrySet = data.entrySet();
        AnnoyingData file = this.getTableFromDatabase(table);
        ConfigurationSection targetData = file.getConfigurationSection(target);
        if (targetData == null) {
            targetData = file.createSection(target);
        }
        for (Map.Entry<String, Value> entry : entrySet) {
            targetData.set(entry.getKey(), (Object)entry.getValue().value);
        }
        HashSet<FailedSet> failed = new HashSet<FailedSet>();
        if (file.save()) {
            return failed;
        }
        for (Map.Entry<String, Value> entry : entrySet) {
            failed.add(new FailedSet(table, target, entry.getKey(), entry.getValue().value));
        }
        return failed;
    }

    @Override
    protected boolean removeFromDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        return this.getTableFromDatabase(table).setSave(target + "." + key, null);
    }
}

