/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.options;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.manymobs.libs.annoyingapi.command.selector.Selector;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.manymobs.libs.annoyingapi.parents.Registrable;

public class RegistrationOptions
extends Stringable {
    @NotNull
    public AutomaticRegistration automaticRegistration = new AutomaticRegistration();
    @NotNull
    public Selectors selectors = new Selectors();
    @NotNull
    public Set<Registrable> toRegister = new HashSet<Registrable>();
    @NotNull
    public Supplier<Object> papiExpansionToRegister = () -> null;

    @NotNull
    public static RegistrationOptions load(@NotNull ConfigurationSection section) {
        ConfigurationSection selectorsSection;
        RegistrationOptions options = new RegistrationOptions();
        ConfigurationSection automaticRegistrationSection = section.getConfigurationSection("automaticRegistration");
        if (automaticRegistrationSection != null) {
            options.automaticRegistration(AutomaticRegistration.load(automaticRegistrationSection));
        }
        if ((selectorsSection = section.getConfigurationSection("selectors")) != null) {
            options.selectors = Selectors.load(selectorsSection);
        }
        return options;
    }

    @NotNull
    public Optional<PlaceholderExpansion> getPapiExpansionToRegister() {
        Object expansion = this.papiExpansionToRegister.get();
        return expansion instanceof PlaceholderExpansion ? Optional.of((PlaceholderExpansion)expansion) : Optional.empty();
    }

    @NotNull
    public RegistrationOptions automaticRegistration(@NotNull AutomaticRegistration automaticRegistration) {
        this.automaticRegistration = automaticRegistration;
        return this;
    }

    @NotNull
    public RegistrationOptions automaticRegistration(@NotNull Consumer<AutomaticRegistration> automaticRegistration) {
        automaticRegistration.accept(this.automaticRegistration);
        return this;
    }

    @NotNull
    public RegistrationOptions toRegister(@NotNull Collection<Registrable> toRegister) {
        this.toRegister.addAll(toRegister);
        return this;
    }

    @NotNull
    public RegistrationOptions toRegister(Registrable ... toRegister) {
        return this.toRegister(Arrays.asList(toRegister));
    }

    @NotNull
    public RegistrationOptions toRegister(@NotNull AnnoyingPlugin plugin, @NotNull Collection<Class<? extends Registrable>> toRegister) {
        for (Class<? extends Registrable> registrable : toRegister) {
            try {
                this.toRegister.add(registrable.getConstructor(((Object)((Object)plugin)).getClass()).newInstance(new Object[]{plugin}));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    @SafeVarargs
    @NotNull
    public final RegistrationOptions toRegister(@NotNull AnnoyingPlugin plugin, Class<? extends Registrable> ... toRegister) {
        return this.toRegister(plugin, Arrays.asList(toRegister));
    }

    @NotNull
    public RegistrationOptions papiExpansionToRegister(@NotNull Supplier<Object> papiExpansionToRegister) {
        this.papiExpansionToRegister = papiExpansionToRegister;
        return this;
    }

    public static class AutomaticRegistration
    extends Stringable {
        @NotNull
        public final Set<String> packages = new HashSet<String>();
        @NotNull
        public final Set<Class<? extends Registrable>> ignoredClasses = new HashSet<Class<? extends Registrable>>();

        @NotNull
        public static AutomaticRegistration load(@NotNull ConfigurationSection section) {
            AutomaticRegistration automaticRegistration = new AutomaticRegistration();
            if (section.contains("packages")) {
                automaticRegistration.packages(section.getStringList("packages"));
            }
            return automaticRegistration;
        }

        @NotNull
        public AutomaticRegistration packages(@NotNull Collection<String> packages) {
            this.packages.addAll(packages);
            return this;
        }

        @NotNull
        public AutomaticRegistration packages(String ... packages) {
            return this.packages(Arrays.asList(packages));
        }

        @NotNull
        public AutomaticRegistration ignoredClasses(@NotNull Collection<Class<? extends Registrable>> ignoredClasses) {
            this.ignoredClasses.addAll(ignoredClasses);
            return this;
        }

        @SafeVarargs
        @NotNull
        public final AutomaticRegistration ignoredClasses(Class<? extends Registrable> ... ignoredClasses) {
            return this.ignoredClasses(Arrays.asList(ignoredClasses));
        }
    }

    public static class Selectors
    extends Stringable {
        public boolean enableDefaultSelectors = true;
        public char defaultSelectorPrefix = (char)33;
        @NotNull
        public final LinkedHashMap<String, Selector<?>> toRegister = new LinkedHashMap();

        @NotNull
        public static Selectors load(@NotNull ConfigurationSection section) {
            Selectors selectors = new Selectors();
            selectors.enableDefaultSelectors = section.getBoolean("enableDefaultSelectors", selectors.enableDefaultSelectors);
            String prefix = section.getString("defaultSelectorPrefix");
            if (prefix != null && !prefix.isEmpty()) {
                selectors.defaultSelectorPrefix = prefix.charAt(0);
            }
            return selectors;
        }

        @NotNull
        public Selectors enableDefaultSelectors(boolean enableDefaultSelectors) {
            this.enableDefaultSelectors = enableDefaultSelectors;
            return this;
        }

        @NotNull
        public Selectors enableDefaultSelectors() {
            this.enableDefaultSelectors = true;
            return this;
        }

        @NotNull
        public Selectors disableDefaultSelectors() {
            this.enableDefaultSelectors = false;
            return this;
        }

        @NotNull
        public Selectors defaultSelectorPrefix(char defaultSelectorPrefix) {
            this.defaultSelectorPrefix = defaultSelectorPrefix;
            return this;
        }

        @NotNull
        public Selectors toRegister(@NotNull Map<String, Selector<?>> toRegister) {
            this.toRegister.putAll(toRegister);
            return this;
        }

        @NotNull
        public Selectors toRegister(@NotNull String key, @NotNull Selector<?> selector) {
            this.toRegister.put(key, selector);
            return this;
        }
    }
}

