/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.objects.encryptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.manipulation.Mapper;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.objects.encryptor.exceptions.TokenExpiredException;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.objects.encryptor.exceptions.TokenInvalidException;

public class Encryptor {
    @NotNull
    private static final String ALGORITHM = "AES";
    @NotNull
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int IV_SIZE = 12;
    private static final int TAG_SIZE = 128;
    @NotNull
    private final SecretKeySpec secret;
    @Nullable
    private final Duration maxAge;

    public Encryptor(@NotNull byte[] secret, @Nullable Duration maxAge) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        this.secret = new SecretKeySpec(secret, ALGORITHM);
        this.maxAge = maxAge;
        if (maxAge != null && maxAge.isNegative()) {
            throw new IllegalArgumentException("maxAge cannot be negative");
        }
        Cipher.getInstance(TRANSFORMATION).init(1, (Key)this.secret, new GCMParameterSpec(128, new byte[12]));
    }

    @Nullable
    private byte[] getCipherText(int mode, byte[] iv, byte[] token) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            GCMParameterSpec spec = new GCMParameterSpec(128, iv);
            cipher.init(mode, (Key)this.secret, spec);
            return cipher.doFinal(token);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public String encrypt(@NotNull JsonElement value) {
        if (value.isJsonNull()) {
            return null;
        }
        byte[] iv = new byte[12];
        new SecureRandom().nextBytes(iv);
        JsonObject payload = new JsonObject();
        payload.addProperty("timestamp", String.valueOf(System.currentTimeMillis()));
        payload.add("value", value);
        byte[] ciphertext = this.getCipherText(1, iv, payload.toString().getBytes(StandardCharsets.UTF_8));
        if (ciphertext == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(12 + ciphertext.length);
        buffer.put(iv);
        buffer.put(ciphertext);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(buffer.array());
    }

    @Nullable
    public JsonElement decrypt(@NotNull String token) throws TokenExpiredException, TokenInvalidException {
        if (token.isEmpty()) {
            throw new TokenInvalidException("Token is empty or invalid");
        }
        byte[] decoded = Base64.getUrlDecoder().decode(token);
        ByteBuffer buffer = ByteBuffer.wrap(decoded);
        byte[] iv = new byte[12];
        buffer.get(iv);
        if (buffer.remaining() < 1) {
            throw new TokenInvalidException("Token is invalid or tampered with, no cipherText found");
        }
        byte[] cipherText = new byte[buffer.remaining()];
        buffer.get(cipherText);
        byte[] decrypted = this.getCipherText(2, iv, cipherText);
        if (decrypted == null) {
            throw new TokenInvalidException("Decryption failed, token is invalid or tampered with");
        }
        String decryptedString = new String(decrypted, StandardCharsets.UTF_8);
        JsonObject jsonObject = (JsonObject)Mapper.toJson(decryptedString).flatMap(element -> Mapper.convertJsonElement(element, JsonObject.class)).orElseThrow(() -> new TokenInvalidException("Decrypted token is not a valid JSON object"));
        if (!jsonObject.has("timestamp") || !jsonObject.has("value")) {
            throw new TokenInvalidException("Decrypted token is missing required fields");
        }
        String timestamp = (String)Mapper.convertJsonElement(jsonObject.get("timestamp"), JsonPrimitive.class).flatMap(primitive -> Mapper.convertJsonPrimitive(primitive, String.class)).orElseThrow(() -> new TokenInvalidException("Timestamp is not a valid string"));
        Long timestampValue = Mapper.toLong(timestamp).orElseThrow(() -> new TokenInvalidException("Timestamp is not a valid long value"));
        if (this.maxAge != null && System.currentTimeMillis() - timestampValue > this.maxAge.toMillis()) {
            throw new TokenExpiredException();
        }
        JsonElement value = jsonObject.get("value");
        return value.isJsonNull() ? null : value;
    }
}

