/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.objects;

import java.util.Optional;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.parents.Stringable;

public class Arguments
extends Stringable {
    @Nullable
    public final String[] args;

    public Arguments(@Nullable String[] args) {
        this.args = args;
    }

    public boolean argEquals(int index, String ... strings) {
        if (this.args == null || this.args.length <= index) {
            return false;
        }
        String arg = this.args[index];
        if (arg == null) {
            return false;
        }
        for (String string : strings) {
            if (!arg.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getArgument(int index) {
        return this.args == null || this.args.length <= index ? null : this.args[index];
    }

    @NotNull
    public Optional<String> getArgumentOptional(int index) {
        return Optional.ofNullable(this.getArgument(index));
    }

    @NotNull
    public String getArgumentsJoined(int start, int end) {
        if (this.args == null || this.args.length <= start) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(" ");
        for (int i = start; i < this.args.length && i < end; ++i) {
            joiner.add(this.args[i]);
        }
        return joiner.toString();
    }

    @NotNull
    public String getArgumentsJoined(int start) {
        return this.args == null ? "" : this.getArgumentsJoined(start, this.args.length);
    }

    @NotNull
    public String getArgumentsJoined() {
        return this.args == null ? "" : String.join((CharSequence)" ", this.args);
    }
}

