/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpUtility {
    public static boolean DEBUG = false;

    @NotNull
    public static <T> Optional<T> get(@NotNull String userAgent, @NotNull String url, @NotNull Function<InputStreamReader, T> function, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        Object result;
        block6: {
            result = null;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(url).toURL().openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", userAgent);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                if (connection.getResponseCode() == 404) {
                    if (DEBUG) {
                        System.out.println("[JU] 404: " + url);
                    }
                    return Optional.empty();
                }
                result = function.apply(new InputStreamReader(connection.getInputStream()));
            }
            catch (Exception e) {
                if (!DEBUG) break block6;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return Optional.ofNullable(result);
    }

    @NotNull
    public static Optional<String> getString(@NotNull String userAgent, @NotNull String urlString, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        return HttpUtility.get(userAgent, urlString, reader -> new BufferedReader((Reader)reader).lines().collect(Collectors.joining("\n")), connectionConsumer);
    }

    @NotNull
    public static Optional<JsonElement> getJson(@NotNull String userAgent, @NotNull String urlString, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        return HttpUtility.get(userAgent, urlString, reader -> new JsonParser().parse((Reader)reader), connection -> {
            connection.setRequestProperty("Accept", "application/json");
            if (connectionConsumer != null) {
                connectionConsumer.accept((HttpURLConnection)connection);
            }
        });
    }

    @NotNull
    public static Optional<Response> post(@NotNull String userAgent, @NotNull String urlString, @Nullable byte[] data, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        Response response;
        block5: {
            response = null;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("User-Agent", userAgent);
                connection.setDoOutput(true);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                if (data != null) {
                    connection.getOutputStream().write(data);
                }
                response = new Response(connection.getResponseCode(), connection.getResponseMessage(), HttpUtility.getResponseBody(connection));
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return Optional.ofNullable(response);
    }

    @NotNull
    public static Optional<Response> postJson(@NotNull String userAgent, @NotNull String urlString, @Nullable JsonElement data, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        return HttpUtility.post(userAgent, urlString, data != null ? data.toString().getBytes() : null, connection -> {
            connection.setRequestProperty("Content-Type", "application/json");
            if (connectionConsumer != null) {
                connectionConsumer.accept((HttpURLConnection)connection);
            }
        });
    }

    @NotNull
    public static Optional<Response> postFormUrlEncoded(@NotNull String userAgent, @NotNull String urlString, @NotNull Map<String, String> formData, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        String formBody = formData.entrySet().stream().map(entry -> {
            try {
                return URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8.name()) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.joining("&"));
        return HttpUtility.post(userAgent, urlString, formBody.getBytes(), connection -> {
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (connectionConsumer != null) {
                connectionConsumer.accept((HttpURLConnection)connection);
            }
        });
    }

    @NotNull
    public static Optional<Response> putJson(@NotNull String userAgent, @NotNull String urlString, @Nullable JsonElement data, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        Response response;
        block5: {
            response = null;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
                connection.setRequestMethod("PUT");
                connection.setRequestProperty("User-Agent", userAgent);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                if (data != null) {
                    connection.getOutputStream().write(data.toString().getBytes());
                }
                response = new Response(connection.getResponseCode(), connection.getResponseMessage(), HttpUtility.getResponseBody(connection));
            }
            catch (Exception e) {
                if (!DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return Optional.ofNullable(response);
    }

    @NotNull
    public static Optional<Response> delete(@NotNull String userAgent, @NotNull String urlString, @Nullable Consumer<HttpURLConnection> connectionConsumer) {
        HttpURLConnection connection;
        Response response;
        block4: {
            response = null;
            connection = null;
            try {
                connection = (HttpURLConnection)URI.create(urlString).toURL().openConnection();
                connection.setRequestMethod("DELETE");
                connection.setRequestProperty("User-Agent", userAgent);
                if (connectionConsumer != null) {
                    connectionConsumer.accept(connection);
                }
                response = new Response(connection.getResponseCode(), connection.getResponseMessage(), HttpUtility.getResponseBody(connection));
            }
            catch (Exception e) {
                if (!DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (connection != null) {
            connection.disconnect();
        }
        return Optional.ofNullable(response);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getResponseBody(@NotNull HttpURLConnection connection) {
        try (InputStream inputStream = connection.getInputStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private HttpUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Response {
        public final int code;
        @Nullable
        public final String message;
        @Nullable
        public final String body;

        public Response(int code, @Nullable String message, @Nullable String body) {
            this.code = code;
            this.message = message;
            this.body = body;
        }
    }
}

