/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.dependency;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.manymobs.libs.annoyingapi.PluginPlatform;
import xyz.srnyx.manymobs.libs.annoyingapi.dependency.AnnoyingDependency;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.HttpUtility;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.manymobs.libs.annoyingapi.parents.Annoyable;

public class AnnoyingDownload
extends Stringable
implements Annoyable {
    @NotNull
    private final AnnoyingPlugin plugin;
    @NotNull
    private final String userAgent;
    @NotNull
    private final List<AnnoyingDependency> dependencies;
    @Nullable
    private Runnable finishRunnable;
    private int remaining = 0;

    public AnnoyingDownload(@NotNull AnnoyingPlugin plugin, @NotNull List<AnnoyingDependency> dependencies) {
        this.plugin = plugin;
        this.userAgent = plugin.getName() + "/" + plugin.getDescription().getVersion() + " via AnnoyingAPI (dependency)";
        this.dependencies = dependencies;
    }

    public AnnoyingDownload(@NotNull AnnoyingPlugin plugin, @NotNull AnnoyingDependency dependency) {
        this(plugin, Collections.singletonList(dependency));
    }

    @Override
    @NotNull
    public AnnoyingPlugin getAnnoyingPlugin() {
        return this.plugin;
    }

    public void downloadPlugins(@Nullable Runnable finishRunnable) {
        this.finishRunnable = finishRunnable;
        this.remaining = this.dependencies.size();
        this.dependencies.forEach(dependency -> this.plugin.scheduler.attemptAsync(() -> this.attemptDownload((AnnoyingDependency)dependency)));
    }

    private void attemptDownload(@NotNull AnnoyingDependency dependency) {
        String name = dependency.name;
        PluginPlatform.Multi platforms = dependency.platforms;
        Optional<String> modrinth = platforms.getIdentifier(PluginPlatform.Platform.MODRINTH);
        if (modrinth.isPresent()) {
            this.modrinth(dependency, modrinth.get());
            return;
        }
        Optional<PluginPlatform> hangar = platforms.get(PluginPlatform.Platform.HANGAR);
        if (hangar.isPresent()) {
            this.hangar(dependency, hangar.get());
            return;
        }
        Optional<String> spigot = platforms.getIdentifier(PluginPlatform.Platform.SPIGOT);
        if (spigot.isPresent()) {
            this.spigot(dependency, spigot.get());
            return;
        }
        Optional<String> bukkit = platforms.getIdentifier(PluginPlatform.Platform.BUKKIT);
        if (bukkit.isPresent()) {
            this.downloadFile(dependency, PluginPlatform.Platform.BUKKIT, "https://dev.bukkit.org/projects/" + bukkit.get() + "/files/latest");
            return;
        }
        Optional<String> external = platforms.getIdentifier(PluginPlatform.Platform.EXTERNAL);
        if (external.isPresent()) {
            this.downloadFile(dependency, PluginPlatform.Platform.EXTERNAL, external.get());
            return;
        }
        Optional<String> manual = platforms.getIdentifier(PluginPlatform.Platform.MANUAL);
        if (manual.isPresent()) {
            AnnoyingPlugin.log(Level.WARNING, "&6" + name + " &8|&e Please install this plugin manually at &6" + manual.get());
            this.finish(dependency, false);
            return;
        }
        AnnoyingPlugin.log(Level.SEVERE, "&4" + name + " &8|&c Ran out of platforms!");
        this.finish(dependency, false);
    }

    private void modrinth(@NotNull AnnoyingDependency dependency, @NotNull String identifier) {
        Optional<String> latest = HttpUtility.getJson(this.userAgent, "https://api.modrinth.com/v2/project/" + identifier + "/version?loaders=%5B%22spigot%22,%22paper%22,%22purpur%22%5D&game_versions=%5B%22" + AnnoyingPlugin.MINECRAFT_VERSION.version + "%22%5D", null).map(element -> element.getAsJsonArray().get(0).getAsJsonObject().getAsJsonArray("files").get(0).getAsJsonObject().get("url").getAsString());
        if (!latest.isPresent()) {
            this.fail(dependency, PluginPlatform.Platform.MODRINTH);
            return;
        }
        this.downloadFile(dependency, PluginPlatform.Platform.MODRINTH, latest.get());
    }

    private void hangar(@NotNull AnnoyingDependency dependency, @NotNull PluginPlatform platform) {
        if (platform.author == null) {
            this.fail(dependency, platform.platform);
            return;
        }
        String url = "https://hangar.papermc.io/api/v1/projects/" + platform.author + "/" + platform.identifier + "/";
        Optional<String> latest = HttpUtility.getString(this.userAgent, url + "latestrelease", null);
        if (!latest.isPresent()) {
            this.fail(dependency, platform.platform);
            return;
        }
        this.downloadFile(dependency, platform.platform, url + "versions/" + latest.get() + "/PAPER/download");
    }

    private void spigot(@NotNull AnnoyingDependency dependency, @NotNull String identifier) {
        PluginPlatform.Multi platforms = dependency.platforms;
        String url = "https://api.spiget.org/v2/resources/" + identifier;
        Optional<JsonObject> json = HttpUtility.getJson(this.userAgent, url, null).map(JsonElement::getAsJsonObject);
        if (!json.isPresent()) {
            this.fail(dependency, PluginPlatform.Platform.SPIGOT);
            return;
        }
        JsonObject object = json.get();
        if (object.get("premium").getAsBoolean()) {
            this.fail(dependency, PluginPlatform.Platform.SPIGOT);
            return;
        }
        if (object.get("external").getAsBoolean()) {
            platforms.remove(PluginPlatform.Platform.SPIGOT);
            String externalUrl = object.get("file").getAsJsonObject().get("externalUrl").getAsString();
            if (externalUrl.endsWith(".jar")) {
                platforms.addIfAbsent(PluginPlatform.external(externalUrl));
            } else {
                platforms.addIfAbsent(PluginPlatform.manual(externalUrl));
            }
            this.attemptDownload(dependency);
            return;
        }
        this.downloadFile(dependency, PluginPlatform.Platform.SPIGOT, url + "/download");
    }

    private void downloadFile(@NotNull AnnoyingDependency dependency, @NotNull PluginPlatform.Platform platform, @NotNull String urlString) {
        HttpURLConnection connection;
        try {
            connection = (HttpURLConnection)new URL(urlString).openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.fail(dependency, platform);
            return;
        }
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
             FileOutputStream out = new FileOutputStream(dependency.file);){
            int numRead;
            byte[] buffer = new byte[1024];
            while ((numRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, numRead);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AnnoyingPlugin.log(Level.INFO, "&2" + dependency.name + " &8|&a Successfully downloaded from &2" + platform.name());
        this.finish(dependency, true);
    }

    private void fail(@NotNull AnnoyingDependency dependency, @NotNull PluginPlatform.Platform platform) {
        dependency.platforms.remove(platform);
        this.attemptDownload(dependency);
    }

    private void finish(@NotNull AnnoyingDependency dependency, boolean enable) {
        PluginManager manager = Bukkit.getPluginManager();
        if (enable && dependency.enableAfterDownload && dependency.isNotInstalled()) {
            try {
                Plugin dependencyPlugin = manager.loadPlugin(dependency.file);
                if (dependencyPlugin == null) {
                    AnnoyingPlugin.log(Level.SEVERE, "&4" + dependency.name + " &8|&c Failed to load plugin!");
                    return;
                }
                dependencyPlugin.onLoad();
                manager.enablePlugin(dependencyPlugin);
            }
            catch (IllegalArgumentException | InvalidDescriptionException | InvalidPluginException e) {
                AnnoyingPlugin.log(Level.SEVERE, "&4" + dependency.name + " &8|&c Failed to load plugin!");
            }
        }
        --this.remaining;
        if (this.remaining != 0) {
            return;
        }
        AnnoyingPlugin.log(Level.INFO, "&a&lAll &2&l" + this.dependencies.size() + "&a&l plugins have been processed! &aPlease resolve any errors and then restart the server.");
        Bukkit.getScheduler().callSyncMethod((Plugin)this.plugin, () -> {
            if (this.finishRunnable != null) {
                this.finishRunnable.run();
            }
            return null;
        });
    }
}

