/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs.libs.annoyingapi.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.manymobs.libs.annoyingapi.command.AnnoyingSender;
import xyz.srnyx.manymobs.libs.annoyingapi.command.DisabledCommand;
import xyz.srnyx.manymobs.libs.annoyingapi.message.AnnoyingMessage;
import xyz.srnyx.manymobs.libs.annoyingapi.parents.Registrable;

public abstract class AnnoyingCommand
extends Registrable
implements TabExecutor {
    @NotNull
    public String getName() {
        return this.getClass().getSimpleName().replace("Command", "").replace("Cmd", "").toLowerCase();
    }

    @Nullable
    public String getPermission() {
        return null;
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @NotNull
    public Predicate<String[]> getArgsPredicate() {
        return args -> true;
    }

    @Override
    public void register() {
        if (this.isRegistered()) {
            return;
        }
        PluginCommand command = this.getAnnoyingPlugin().getCommand(this.getName());
        if (command == null) {
            AnnoyingPlugin.log(Level.WARNING, "&cCommand &4" + this.getName() + "&c not found in plugin.yml!");
            return;
        }
        command.setExecutor((CommandExecutor)this);
        super.register();
    }

    @Override
    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        PluginCommand command = this.getAnnoyingPlugin().getCommand(this.getName());
        if (command != null) {
            command.setExecutor((CommandExecutor)new DisabledCommand(this.getAnnoyingPlugin()));
        }
        super.unregister();
    }

    public abstract void onCommand(@NotNull AnnoyingSender var1);

    @Nullable
    public Collection<String> onTabComplete(@NotNull AnnoyingSender sender) {
        return null;
    }

    public boolean onCommand(@NotNull CommandSender cmdSender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        AnnoyingSender sender = new AnnoyingSender(this.getAnnoyingPlugin(), cmdSender, cmd, label, args);
        String permission = this.getPermission();
        if (permission != null && !sender.checkPermission(permission) || this.isPlayerOnly() && !sender.checkPlayer()) {
            return true;
        }
        if (!this.getArgsPredicate().test(args)) {
            new AnnoyingMessage(this.getAnnoyingPlugin(), this.getAnnoyingPlugin().options.messagesOptions.keys.invalidArguments).send(sender);
            return true;
        }
        this.onCommand(sender);
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender cmdSender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        String permission = this.getPermission();
        if (permission != null && !cmdSender.hasPermission(permission)) {
            return Collections.emptyList();
        }
        Collection<String> suggestions = this.onTabComplete(new AnnoyingSender(this.getAnnoyingPlugin(), cmdSender, cmd, label, args));
        if (suggestions == null) {
            return Collections.emptyList();
        }
        return suggestions.stream().filter(string -> string.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

