/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.manymobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.manymobs.ManyMobs;
import xyz.srnyx.manymobs.libs.annoyingapi.command.AnnoyingCommand;
import xyz.srnyx.manymobs.libs.annoyingapi.command.AnnoyingSender;
import xyz.srnyx.manymobs.libs.annoyingapi.command.selector.SelectorOptional;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.StringUtility;
import xyz.srnyx.manymobs.libs.annoyingapi.libs.javautilities.manipulation.Mapper;
import xyz.srnyx.manymobs.libs.annoyingapi.message.AnnoyingMessage;
import xyz.srnyx.manymobs.libs.annoyingapi.message.DefaultReplaceType;
import xyz.srnyx.manymobs.libs.annoyingapi.utility.BukkitUtility;

public class ManymobsCommand
extends AnnoyingCommand {
    @NotNull
    private final ManyMobs plugin;

    public ManymobsCommand(@NotNull ManyMobs plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public ManyMobs getAnnoyingPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public String getPermission() {
        return "manymobs.command";
    }

    @Override
    public void onCommand(@NotNull AnnoyingSender sender) {
        List<Location> locations;
        if (sender.args.length == 1 && sender.argEquals(0, "reload")) {
            this.plugin.reloadPlugin();
            new AnnoyingMessage(this.plugin, "command.reload").send(sender);
            return;
        }
        if (sender.args.length < 2 || !sender.argEquals(0, "spawn")) {
            sender.invalidArguments();
            return;
        }
        EntityType type = sender.getArgumentOptionalFlat(1, arg -> Mapper.toEnum(arg, EntityType.class)).orElse(null);
        if (type == null) {
            return;
        }
        Integer amount = 1;
        if (sender.args.length >= 3) {
            amount = sender.getArgumentOptionalFlat(2, Mapper::toInt).orElse(null);
            if (amount == null) {
                return;
            }
            if (amount <= 0) {
                sender.invalidArgument(amount);
                return;
            }
        }
        if (sender.args.length >= 4) {
            locations = this.getLocations(sender);
            if (locations == null) {
                return;
            }
        } else {
            if (!sender.checkPlayer()) {
                return;
            }
            locations = Collections.singletonList(sender.getPlayer().getLocation());
        }
        for (Location location : locations) {
            World world = location.getWorld();
            for (int i = 0; i < amount; ++i) {
                world.spawnEntity(location, type);
            }
        }
        if (!this.plugin.config.enableSpawnMessages) {
            return;
        }
        if (locations.size() == 1) {
            Location location = locations.get(0);
            double x = location.getX();
            double y = location.getY();
            double z = location.getZ();
            float yaw = location.getYaw();
            float pitch = location.getPitch();
            new AnnoyingMessage(this.plugin, "command.spawn").replace("%amount%", amount).replace("%type%", type.name()).replace("%world%", location.getWorld().getName()).replace("%x%", x, DefaultReplaceType.NUMBER).replace("%y%", y, DefaultReplaceType.NUMBER).replace("%z%", z, DefaultReplaceType.NUMBER).replace("%yaw%", Float.valueOf(yaw), DefaultReplaceType.NUMBER).replace("%pitch%", Float.valueOf(pitch), DefaultReplaceType.NUMBER).replace("%location%", x + ", " + y + ", " + z + ", " + yaw + ", " + pitch).send(sender);
        } else {
            new AnnoyingMessage(this.plugin, "command.spawn-multiple").replace("%amount%", amount).replace("%type%", type.name()).replace("%locations%", locations.size()).send(sender);
        }
    }

    @Override
    @Nullable
    public Collection<String> onTabComplete(@NotNull AnnoyingSender sender) {
        if (sender.args.length == 1) {
            return Arrays.asList("reload", "spawn");
        }
        if (sender.argEquals(0, "spawn")) {
            int argOffset;
            Location location = sender.getPlayer().getLocation();
            if (sender.args.length == 2) {
                return Arrays.stream(EntityType.values()).map(Enum::name).collect(Collectors.toList());
            }
            if (sender.args.length == 3) {
                return Collections.singleton("[<amount>]");
            }
            if (sender.args.length == 4) {
                ArrayList<String> results = new ArrayList<String>();
                results.add(StringUtility.formatNumber(location.getX(), "#.##"));
                for (World world : Bukkit.getWorlds()) {
                    results.add("#" + world.getName());
                }
                this.plugin.selectorManager.addKeysTo(results, Player.class);
                results.addAll(BukkitUtility.getOnlinePlayerNames());
                return results;
            }
            String argument3 = sender.getArgument(3);
            int n = argOffset = argument3 != null && Bukkit.getWorld((String)argument3.substring(1)) != null ? 1 : 0;
            if (sender.args.length == 5 && argOffset == 1) {
                return Collections.singleton(StringUtility.formatNumber(location.getX(), "#.##"));
            }
            if (sender.args.length == 5 + argOffset) {
                return Collections.singleton(StringUtility.formatNumber(location.getY(), "#.##"));
            }
            if (sender.args.length == 6 + argOffset) {
                return Collections.singleton(StringUtility.formatNumber(location.getZ(), "#.##"));
            }
            if (sender.args.length == 7 + argOffset) {
                return Collections.singleton(StringUtility.formatNumber(Float.valueOf(location.getYaw()), "#.##"));
            }
            if (sender.args.length == 8 + argOffset) {
                return Collections.singleton(StringUtility.formatNumber(Float.valueOf(location.getPitch()), "#.##"));
            }
        }
        return null;
    }

    @Nullable
    private List<Location> getLocations(@NotNull AnnoyingSender sender) {
        World world;
        String argument3 = sender.getArgument(3);
        if (argument3 == null) {
            return null;
        }
        SelectorOptional<Player> selector = SelectorOptional.of(sender, argument3, Player.class);
        if (selector.isPresent()) {
            List<Player> players = selector.getSelector().expand(sender);
            if (players == null) {
                sender.invalidArgument(3);
                return null;
            }
            ArrayList<Location> locations = new ArrayList<Location>();
            for (Player player : players) {
                locations.add(player.getLocation());
            }
            return locations;
        }
        if (sender.args.length < 6) {
            sender.invalidArguments();
            return null;
        }
        int argOffset = 0;
        if (argument3.startsWith("#")) {
            if (sender.args.length < 7) {
                sender.invalidArguments();
                return null;
            }
            world = Bukkit.getWorld((String)argument3.substring(1));
            if (world == null) {
                sender.invalidArgument(3);
                return null;
            }
            argOffset = 1;
        } else {
            if (!sender.checkPlayer()) {
                return null;
            }
            world = sender.getPlayer().getWorld();
        }
        Double x = sender.getArgumentOptionalFlat(3 + argOffset, Mapper::toDouble).orElse(null);
        if (x == null) {
            return null;
        }
        Double y = sender.getArgumentOptionalFlat(4 + argOffset, Mapper::toDouble).orElse(null);
        if (y == null) {
            return null;
        }
        Double z = sender.getArgumentOptionalFlat(5 + argOffset, Mapper::toDouble).orElse(null);
        if (z == null) {
            return null;
        }
        Location location = new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
        if (sender.args.length >= 7 + argOffset) {
            Float yaw = sender.getArgumentOptionalFlat(6 + argOffset, Mapper::toFloat).orElse(null);
            if (yaw == null) {
                return null;
            }
            location.setYaw(yaw.floatValue());
        }
        if (sender.args.length >= 8 + argOffset) {
            Float pitch = sender.getArgumentOptionalFlat(7 + argOffset, Mapper::toFloat).orElse(null);
            if (pitch == null) {
                return null;
            }
            location.setPitch(pitch.floatValue());
        }
        return Collections.singletonList(location);
    }
}

