/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.managers;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.LimitedLives;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPAPIExpansion;
import xyz.srnyx.limitedlives.managers.player.PlayerManager;

public class PlaceholderManager
extends AnnoyingPAPIExpansion {
    @NotNull
    private final LimitedLives plugin;

    public PlaceholderManager(@NotNull LimitedLives plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public LimitedLives getAnnoyingPlugin() {
        return this.plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "lives";
    }

    @Nullable
    public String onPlaceholderRequest(@Nullable Player player, @NotNull String identifier) {
        switch (identifier) {
            case "default": {
                return String.valueOf(this.plugin.config.lives.def);
            }
            case "max": {
                return String.valueOf(this.plugin.config.lives.max);
            }
            case "min": {
                return String.valueOf(this.plugin.config.lives.min);
            }
        }
        if (player == null) {
            int underscoreIndex = identifier.indexOf(95);
            if (underscoreIndex == -1) {
                return null;
            }
            player = Bukkit.getPlayerExact((String)identifier.substring(underscoreIndex + 1));
            if (player == null) {
                return "N/A";
            }
            identifier = identifier.substring(0, underscoreIndex).toLowerCase();
        }
        switch (identifier) {
            case "lives": {
                return String.valueOf(new PlayerManager(this.plugin, (OfflinePlayer)player).getLives());
            }
            case "max": {
                return String.valueOf(new PlayerManager(this.plugin, (OfflinePlayer)player).getMaxLives());
            }
            case "grace-active": {
                return String.valueOf(new PlayerManager(this.plugin, (OfflinePlayer)player).hasGrace());
            }
            case "grace-left": {
                return String.valueOf(new PlayerManager(this.plugin, (OfflinePlayer)player).getGraceLeft());
            }
            case "bypass": {
                return String.valueOf(player.hasPermission("limitedlives.bypass"));
            }
        }
        return null;
    }
}

