/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.listeners;

import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.limitedlives.LimitedLives;
import xyz.srnyx.limitedlives.config.Feature;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingListener;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.data.ItemData;
import xyz.srnyx.limitedlives.libs.annoyingapi.message.AnnoyingMessage;
import xyz.srnyx.limitedlives.managers.player.PlayerManager;
import xyz.srnyx.limitedlives.managers.player.exception.MoreThanMaxLives;

public class PlayerItemConsumeListener
extends AnnoyingListener {
    @NotNull
    private final LimitedLives plugin;

    public PlayerItemConsumeListener(@NotNull LimitedLives plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public LimitedLives getAnnoyingPlugin() {
        return this.plugin;
    }

    @EventHandler
    public void onPlayerItemConsume(@NotNull PlayerItemConsumeEvent event) {
        if (!new ItemData((AnnoyingPlugin)this.plugin, event.getItem()).has("ll_item")) {
            return;
        }
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!this.plugin.config.worldsBlacklist.isWorldEnabled(world, Feature.LIFE_USE)) {
            new AnnoyingMessage(this.plugin, "feature-disabled").replace("%feature%", (Object)Feature.LIFE_USE).replace("%world%", world.getName()).send((CommandSender)player);
            event.setCancelled(true);
            return;
        }
        try {
            new AnnoyingMessage(this.plugin, "eat.success").replace("%lives%", new PlayerManager(this.plugin, (OfflinePlayer)player).addLives(this.plugin.config.obtaining.crafting.amount)).send((CommandSender)player);
        }
        catch (MoreThanMaxLives e) {
            event.setCancelled(true);
            new AnnoyingMessage(this.plugin, "eat.max").replace("%max%", this.plugin.config.lives.max).send((CommandSender)player);
        }
    }
}

