/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.storage.dialects;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.FileUtility;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.MiscUtility;
import xyz.srnyx.limitedlives.libs.annoyingapi.storage.DataManager;
import xyz.srnyx.limitedlives.libs.annoyingapi.storage.FailedSet;
import xyz.srnyx.limitedlives.libs.annoyingapi.storage.Value;
import xyz.srnyx.limitedlives.libs.annoyingapi.storage.dialects.Dialect;

public class JSONDialect
extends Dialect {
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private final File folder;
    @NotNull
    private final Map<String, JsonFile> tables;

    public JSONDialect(@NotNull DataManager dataManager) {
        super(dataManager);
        this.folder = this.dataManager.plugin.getDataFolder().toPath().resolve("data/json").toFile();
        this.tables = new HashMap<String, JsonFile>();
    }

    @NotNull
    private Optional<JsonFile> getTableFromCache(@NotNull String table) {
        return Optional.ofNullable(this.tables.get(table));
    }

    @Override
    @Nullable
    public Value getFromCacheImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        return this.getTableFromCache(table).map(file -> ((JsonFile)file).get(target, key)).orElse(null);
    }

    @Override
    public void setToCacheImpl(@NotNull String table, @NotNull String target, @NotNull String key, @NotNull Value value) {
        this.getTableFromCache(table).orElseGet(() -> {
            JsonFile newFile = this.getTableFromDatabase(table);
            this.tables.put(table, newFile);
            return newFile;
        }).set(target, key, value.value);
    }

    @Override
    public void markRemovedInCacheImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        this.getTableFromCache(table).ifPresent(file -> ((JsonFile)file).remove(target, key));
    }

    @Override
    public void saveCacheImpl() {
        for (JsonFile file : this.tables.values()) {
            file.save();
        }
    }

    @Override
    public void saveCacheImpl(@NotNull String table, @NotNull String target) {
        this.getTableFromCache(table).ifPresent(rec$ -> ((JsonFile)rec$).save());
    }

    @NotNull
    private JsonFile getTableFromDatabase(@NotNull String table) {
        File file = new File(this.folder, table + ".json");
        JsonObject json = new JsonObject();
        if (file.exists()) {
            try (FileReader fileReader = new FileReader(file);){
                json = (JsonObject)GSON.fromJson((Reader)fileReader, JsonObject.class);
            }
            catch (JsonParseException | IOException e) {
                AnnoyingPlugin.log(Level.SEVERE, "&cFailed to read file for table &4" + table, e);
            }
        }
        return new JsonFile(file, json);
    }

    @Override
    @NotNull
    protected Optional<Dialect.MigrationData> getMigrationDataFromDatabaseImpl(@NotNull DataManager newManager) {
        HashMap<String, Set<String>> tablesKeys = new HashMap<String, Set<String>>();
        ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>> data = new ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, Value>>>();
        for (String table : FileUtility.getFileNames(this.folder, "json")) {
            HashSet<String> keys = new HashSet<String>();
            ConcurrentHashMap targetData = new ConcurrentHashMap();
            for (Map.Entry entry : this.getTableFromDatabase((String)table).json.entrySet()) {
                JsonElement entryElement = (JsonElement)entry.getValue();
                if (!entryElement.isJsonObject()) continue;
                ConcurrentHashMap<String, Value> targetMap = new ConcurrentHashMap<String, Value>();
                for (Map.Entry targetEntry : entryElement.getAsJsonObject().entrySet()) {
                    String key = (String)targetEntry.getKey();
                    keys.add(key);
                    targetMap.put(key, new Value(((JsonElement)targetEntry.getValue()).getAsString()));
                }
                targetData.put((String)entry.getKey(), targetMap);
            }
            tablesKeys.put(table, keys);
            data.put(table, targetData);
        }
        return Optional.of(new Dialect.MigrationData(tablesKeys, data));
    }

    @Override
    @NotNull
    protected Optional<String> getFromDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        return Optional.ofNullable(this.getTableFromDatabase(table).get(target, key)).map(value -> value.value);
    }

    @Override
    @Nullable
    protected FailedSet setToDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull String key, @NotNull String value) {
        JsonFile file = this.getTableFromDatabase(table);
        file.set(target, key, value);
        return file.save() ? null : new FailedSet(table, target, key, value);
    }

    @Override
    @NotNull
    protected Set<FailedSet> setToDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull ConcurrentHashMap<String, Value> data) {
        Set<Map.Entry<String, Value>> entrySet = data.entrySet();
        JsonFile file = this.getTableFromDatabase(table);
        JsonObject targetData = file.getTargetDataCreate(target);
        for (Map.Entry<String, Value> entry : entrySet) {
            targetData.addProperty(entry.getKey(), entry.getValue().value);
        }
        HashSet<FailedSet> failed = new HashSet<FailedSet>();
        if (file.save()) {
            return failed;
        }
        for (Map.Entry<String, Value> entry : entrySet) {
            failed.add(new FailedSet(table, target, entry.getKey(), entry.getValue().value));
        }
        return failed;
    }

    @Override
    protected boolean removeFromDatabaseImpl(@NotNull String table, @NotNull String target, @NotNull String key) {
        JsonFile file = this.getTableFromDatabase(table);
        file.remove(target, key);
        return file.save();
    }

    public static class JsonFile {
        @NotNull
        private final File file;
        @NotNull
        public final JsonObject json;

        private JsonFile(@NotNull File file, @NotNull JsonObject json) {
            this.file = file;
            this.json = json;
        }

        @NotNull
        private Optional<JsonObject> getTargetData(@NotNull String target) {
            return MiscUtility.handleException(() -> this.json.getAsJsonObject(target));
        }

        @NotNull
        private JsonObject getTargetDataCreate(@NotNull String target) {
            return MiscUtility.handleException(() -> this.json.getAsJsonObject(target)).orElseGet(() -> {
                JsonObject jsonObject = new JsonObject();
                this.json.add(target, (JsonElement)jsonObject);
                return jsonObject;
            });
        }

        @Nullable
        private Value get(@NotNull String target, @NotNull String key) {
            return this.getTargetData(target).flatMap(jsonObject -> MiscUtility.handleException(() -> jsonObject.get(key).getAsString())).map(Value::new).orElse(null);
        }

        private void set(@NotNull String target, @NotNull String key, @Nullable String value) {
            this.getTargetDataCreate(target).addProperty(key, value);
        }

        private void remove(@NotNull String target, @NotNull String key) {
            this.getTargetData(target).ifPresent(jsonObject -> jsonObject.remove(key));
        }

        private boolean save() {
            boolean bl;
            if (!this.file.exists()) {
                try {
                    Files.createDirectories(this.file.getParentFile().toPath(), new FileAttribute[0]);
                    Files.createFile(this.file.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    AnnoyingPlugin.log(Level.SEVERE, "&cFailed to create file for table &4" + this.file.getName(), e);
                    return false;
                }
            }
            FileWriter fileWriter = new FileWriter(this.file);
            try {
                fileWriter.write(GSON.toJson((JsonElement)this.json));
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileWriter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    AnnoyingPlugin.log(Level.SEVERE, "&cFailed to save file for table &4" + this.file.getName(), e);
                    return false;
                }
            }
            fileWriter.close();
            return bl;
        }
    }
}

