/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.reflection.org.bukkit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.reflection.org.bukkit.RefGameRule;
import xyz.srnyx.limitedlives.libs.annoyingapi.reflection.org.bukkit.RefSoundCategory;
import xyz.srnyx.limitedlives.libs.annoyingapi.utility.ReflectionUtility;

public class RefWorld {
    @Nullable
    public static final Method WORLD_GET_GAME_RULE_VALUE_METHOD = ReflectionUtility.getMethod(1, 13, 0, World.class, "getGameRuleValue", RefGameRule.GAME_RULE_CLASS);
    @Nullable
    public static final Method WORLD_SET_GAME_RULE_VALUE_METHOD = ReflectionUtility.getMethod(1, 13, 0, World.class, "setGameRuleValue", RefGameRule.GAME_RULE_CLASS, Object.class);
    @Nullable
    public static final Method WORLD_PLAY_SOUND_METHOD = ReflectionUtility.getMethod(1, 11, 0, World.class, "playSound", Location.class, Sound.class, RefSoundCategory.SOUND_CATEGORY_ENUM, Float.TYPE, Float.TYPE);

    @Nullable
    public static String getGameRuleValue(@NotNull World world, @NotNull String legacyName, @Nullable Object modernEnum) {
        if (WORLD_GET_GAME_RULE_VALUE_METHOD != null && modernEnum != null) {
            try {
                return String.valueOf(WORLD_GET_GAME_RULE_VALUE_METHOD.invoke((Object)world, modernEnum));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return null;
            }
        }
        return world.getGameRuleValue(legacyName);
    }

    public static void setGameRuleValue(@NotNull World world, @NotNull String legacyName, @Nullable Object modernEnum, @NotNull Object value) {
        if (WORLD_SET_GAME_RULE_VALUE_METHOD != null && modernEnum != null) {
            try {
                WORLD_SET_GAME_RULE_VALUE_METHOD.invoke((Object)world, modernEnum, value);
            }
            catch (IllegalAccessException | InvocationTargetException ignored) {
                AnnoyingPlugin.log(Level.WARNING, "Failed to set game rule " + legacyName + " to " + value + " in world " + world.getName());
            }
            return;
        }
        world.setGameRuleValue(legacyName, String.valueOf(value));
    }

    private RefWorld() {
        throw new UnsupportedOperationException("This is a reflected class and cannot be instantiated");
    }
}

