/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.options;

import java.util.function.Consumer;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.file.AnnoyingResource;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.parents.Stringable;

public class MessagesOptions
extends Stringable {
    @NotNull
    public String fileName = "messages.yml";
    @Nullable
    public AnnoyingResource.Options fileOptions = null;
    @NotNull
    public MessageKeys keys = new MessageKeys();

    @NotNull
    public static MessagesOptions load(@NotNull ConfigurationSection section) {
        ConfigurationSection keysSection;
        ConfigurationSection fileOptionsSection;
        MessagesOptions options = new MessagesOptions();
        String fileNameString = section.getString("fileName");
        if (fileNameString != null) {
            options.fileName(fileNameString);
        }
        if ((fileOptionsSection = section.getConfigurationSection("fileOptions")) != null) {
            options.fileOptions(AnnoyingResource.Options.load(fileOptionsSection));
        }
        if ((keysSection = section.getConfigurationSection("keys")) != null) {
            options.keys(MessageKeys.load(keysSection));
        }
        return options;
    }

    @NotNull
    public MessagesOptions fileName(@NotNull String fileName) {
        this.fileName = fileName;
        return this;
    }

    @NotNull
    public MessagesOptions fileOptions(@Nullable AnnoyingResource.Options fileOptions) {
        this.fileOptions = fileOptions;
        return this;
    }

    @NotNull
    public MessagesOptions fileOptions(@NotNull Consumer<AnnoyingResource.Options> consumer) {
        AnnoyingResource.Options options = new AnnoyingResource.Options();
        consumer.accept(options);
        return this.fileOptions(options);
    }

    @NotNull
    public MessagesOptions keys(@NotNull MessageKeys keys) {
        this.keys = keys;
        return this;
    }

    @NotNull
    public MessagesOptions keys(@NotNull Consumer<MessageKeys> consumer) {
        consumer.accept(this.keys);
        return this;
    }

    public static class MessageKeys
    extends Stringable {
        @NotNull
        public String format = "plugin.format";
        @NotNull
        public String globalPlaceholders = "plugin.global-placeholders";
        @NotNull
        public String splitterJson = "plugin.splitters.json";
        @NotNull
        public String splitterPlaceholder = "plugin.splitters.placeholder";
        @NotNull
        public String updateAvailable = "plugin.update-available";
        @NotNull
        public String noPermission = "error.no-permission";
        @NotNull
        public String playerOnly = "error.player-only";
        @NotNull
        public String invalidArgument = "error.invalid-argument";
        @NotNull
        public String invalidArguments = "error.invalid-arguments";
        @NotNull
        public String disabledCommand = "error.disabled-command";

        @NotNull
        public static MessageKeys load(@NotNull ConfigurationSection section) {
            String disabledCommandString;
            String invalidArgumentsString;
            String invalidArgumentString;
            String playerOnlyString;
            String noPermissionString;
            String updateAvailableString;
            String splitterPlaceholderString;
            String splitterJsonString;
            MessageKeys keys = new MessageKeys();
            String globalPlaceholdersString = section.getString("globalPlaceholders");
            if (globalPlaceholdersString != null) {
                keys.globalPlaceholders(globalPlaceholdersString);
            }
            if ((splitterJsonString = section.getString("splitterJson")) != null) {
                keys.splitterJson(splitterJsonString);
            }
            if ((splitterPlaceholderString = section.getString("splitterPlaceholder")) != null) {
                keys.splitterPlaceholder(splitterPlaceholderString);
            }
            if ((updateAvailableString = section.getString("updateAvailable")) != null) {
                keys.updateAvailable(updateAvailableString);
            }
            if ((noPermissionString = section.getString("noPermission")) != null) {
                keys.noPermission(noPermissionString);
            }
            if ((playerOnlyString = section.getString("playerOnly")) != null) {
                keys.playerOnly(playerOnlyString);
            }
            if ((invalidArgumentString = section.getString("invalidArgument")) != null) {
                keys.invalidArgument(invalidArgumentString);
            }
            if ((invalidArgumentsString = section.getString("invalidArguments")) != null) {
                keys.invalidArguments(invalidArgumentsString);
            }
            if ((disabledCommandString = section.getString("disabledCommand")) != null) {
                keys.disabledCommand(disabledCommandString);
            }
            return keys;
        }

        @NotNull
        public MessageKeys format(@NotNull String format) {
            this.format = format;
            return this;
        }

        @NotNull
        public MessageKeys globalPlaceholders(@NotNull String globalPlaceholders) {
            this.globalPlaceholders = globalPlaceholders;
            return this;
        }

        @NotNull
        public MessageKeys splitterJson(@NotNull String splitterJson) {
            this.splitterJson = splitterJson;
            return this;
        }

        @NotNull
        public MessageKeys splitterPlaceholder(@NotNull String splitterPlaceholder) {
            this.splitterPlaceholder = splitterPlaceholder;
            return this;
        }

        @NotNull
        public MessageKeys updateAvailable(@NotNull String updateAvailable) {
            this.updateAvailable = updateAvailable;
            return this;
        }

        @NotNull
        public MessageKeys noPermission(@NotNull String noPermission) {
            this.noPermission = noPermission;
            return this;
        }

        @NotNull
        public MessageKeys playerOnly(@NotNull String playerOnly) {
            this.playerOnly = playerOnly;
            return this;
        }

        @NotNull
        public MessageKeys invalidArgument(@NotNull String invalidArgument) {
            this.invalidArgument = invalidArgument;
            return this;
        }

        @NotNull
        public MessageKeys invalidArguments(@NotNull String invalidArguments) {
            this.invalidArguments = invalidArguments;
            return this;
        }

        @NotNull
        public MessageKeys disabledCommand(@NotNull String disabledCommand) {
            this.disabledCommand = disabledCommand;
            return this;
        }
    }
}

