/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.objects;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.parents.Stringable;

public class SemanticVersion
extends Stringable
implements Comparable<SemanticVersion> {
    @NotNull
    public final String version;
    public final int major;
    public final int minor;
    public final int patch;

    public SemanticVersion(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer patch) {
        this.version = major + "." + minor + "." + patch;
        this.major = major == null ? 0 : major;
        this.minor = minor == null ? 0 : minor;
        this.patch = patch == null ? 0 : patch;
    }

    public SemanticVersion(@NotNull String version) {
        this.version = version.replaceAll("[^0-9.]", "");
        String[] split = this.version.split("\\.");
        this.major = Integer.parseInt(split[0]);
        this.minor = split.length > 1 ? Integer.parseInt(split[1]) : 0;
        this.patch = split.length > 2 ? Integer.parseInt(split[2]) : 0;
    }

    @Override
    @NotNull
    public String toString() {
        return this.version;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof SemanticVersion) {
            return this.compareTo((SemanticVersion)other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    @Override
    public int compareTo(@NotNull SemanticVersion other) {
        if (this.major != other.major) {
            return this.major - other.major;
        }
        if (this.minor != other.minor) {
            return this.minor - other.minor;
        }
        return this.patch - other.patch;
    }

    public int compareTo(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer patch) {
        return this.compareTo(new SemanticVersion(major, minor, patch));
    }

    public boolean isGreaterThan(@NotNull SemanticVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThan(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer patch) {
        return this.compareTo(major, minor, patch) > 0;
    }

    public boolean isGreaterThanOrEqualTo(@NotNull SemanticVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isGreaterThanOrEqualTo(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer patch) {
        return this.compareTo(major, minor, patch) >= 0;
    }

    public boolean isLessThan(@NotNull SemanticVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThan(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer patch) {
        return this.compareTo(major, minor, patch) < 0;
    }

    public boolean isLessThanOrEqualTo(@NotNull SemanticVersion other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isLessThanOrEqualTo(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer patch) {
        return this.compareTo(major, minor, patch) <= 0;
    }
}

