/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.library;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.library.AnnoyingLibrary;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.libby.Library;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.libby.relocation.Relocation;

public enum RuntimeLibrary implements AnnoyingLibrary
{
    BSTATS_BASE(() -> Library.builder().repository("https://repo1.maven.org/maven2/").groupId("org{}bstats").artifactId("bstats-base").version("3.1.0"), plugin -> Collections.singleton(plugin.getRelocation("org{}bstats"))),
    BSTATS_BUKKIT(() -> Library.builder().repository("https://repo1.maven.org/maven2/").groupId("org{}bstats").artifactId("bstats-bukkit").version("3.1.0"), plugin -> Collections.singleton(plugin.getRelocation("org{}bstats"))),
    JAVASSIST(() -> Library.builder().repository("https://repo1.maven.org/maven2/").groupId("org{}javassist").artifactId("javassist").version("3.28.0-GA"), plugin -> Collections.singleton(plugin.getRelocation("javassist{}", "javassist{}"))),
    REFLECTIONS(() -> Library.builder().repository("https://repo1.maven.org/maven2/").groupId("org{}reflections").artifactId("reflections").version("0.10.2"), plugin -> Arrays.asList(plugin.getRelocation("javassist{}", "javassist{}"), plugin.getRelocation("org{}reflections"))),
    ITEM_NBT_API(() -> Library.builder().repository("https://repo.codemc.org/repository/maven-public/").groupId("de{}tr7zw").artifactId("item-nbt-api").version("2.15.5"), plugin -> Collections.singleton(plugin.getRelocation("de{}tr7zw{}changeme{}nbtapi"))),
    H2(() -> Library.builder().repository("https://repo1.maven.org/maven2/").groupId("com{}h2database").artifactId("h2").version("2.2.224"), plugin -> Collections.singleton(plugin.getRelocation("org{}h2"))),
    POSTGRESQL(() -> Library.builder().repository("https://repo1.maven.org/maven2/").groupId("org{}postgresql").artifactId("postgresql").version("42.7.8"), plugin -> Collections.singleton(plugin.getRelocation("org{}postgresql")));

    @NotNull
    public final Supplier<Library.Builder> librarySupplier;
    @NotNull
    public final Function<AnnoyingPlugin, Collection<Relocation>> relocations;

    private RuntimeLibrary(Supplier<Library.Builder> librarySupplier, Function<AnnoyingPlugin, Collection<Relocation>> relocations) {
        this.librarySupplier = librarySupplier;
        this.relocations = relocations;
    }

    @Override
    @NotNull
    public Supplier<Library.Builder> getLibrarySupplier() {
        return this.librarySupplier;
    }

    @Override
    @NotNull
    public Function<AnnoyingPlugin, Collection<Relocation>> getRelocations() {
        return this.relocations;
    }
}

