/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.command.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.Selector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.AllPlayersSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.EntitiesSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.NearestEntitySelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.NearestPlayerSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.OfflineSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.OnlineSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.RandomEntitySelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.RandomPlayerSelector;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.selector.selectors.SelfSelector;

public class SelectorManager {
    @NotNull
    private final AnnoyingPlugin plugin;
    @NotNull
    public final Map<String, Selector<?>> selectors = new LinkedHashMap();

    public SelectorManager(@NotNull AnnoyingPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerSelectors() {
        if (this.plugin.options.registrationOptions.selectors.enableDefaultSelectors) {
            char prefix = this.plugin.options.registrationOptions.selectors.defaultSelectorPrefix;
            this.selectors.put(prefix + "all_players", new AllPlayersSelector());
            this.selectors.put(prefix + "online", new OnlineSelector());
            this.selectors.put(prefix + "offline", new OfflineSelector());
            this.selectors.put(prefix + "self", new SelfSelector());
            this.selectors.put(prefix + "nearest_player", new NearestPlayerSelector());
            this.selectors.put(prefix + "random_player", new RandomPlayerSelector());
            this.selectors.put(prefix + "entities", new EntitiesSelector());
            this.selectors.put(prefix + "nearest_entity", new NearestEntitySelector());
            this.selectors.put(prefix + "random_entity", new RandomEntitySelector());
        }
        this.selectors.putAll(this.plugin.options.registrationOptions.selectors.toRegister);
    }

    @NotNull
    public List<String> getKeys() {
        return new ArrayList<String>(this.selectors.keySet());
    }

    @NotNull
    public List<String> getKeys(@NotNull Class<?> type) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, Selector<?>> entry : this.selectors.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue().getType())) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    @NotNull
    public Collection<String> withKeys(@NotNull Collection<String> collection) {
        List<String> result = this.getKeys();
        result.addAll(collection);
        return result;
    }

    @NotNull
    public List<String> withKeys(@NotNull Collection<String> collection, @NotNull Class<?> type) {
        List<String> result = this.getKeys(type);
        result.addAll(collection);
        return result;
    }

    @NotNull
    public Collection<String> addKeysTo(@NotNull Collection<String> collection) {
        collection.addAll(this.getKeys());
        return collection;
    }

    @NotNull
    public Collection<String> addKeysTo(@NotNull Collection<String> collection, @NotNull Class<?> type) {
        collection.addAll(this.getKeys(type));
        return collection;
    }
}

