/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.bukkit.plugin.PluginBase;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.PluginPlatform;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.HttpUtility;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.objects.SemanticVersion;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.limitedlives.libs.annoyingapi.message.AnnoyingMessage;
import xyz.srnyx.limitedlives.libs.annoyingapi.parents.Annoyable;

public class AnnoyingUpdate
extends Stringable
implements Annoyable {
    @NotNull
    private static final String MINECRAFT_VERSION_SHORT = AnnoyingPlugin.MINECRAFT_VERSION.patch != 0 ? AnnoyingPlugin.MINECRAFT_VERSION.version : AnnoyingPlugin.MINECRAFT_VERSION.major + "." + AnnoyingPlugin.MINECRAFT_VERSION.minor;
    @NotNull
    private final AnnoyingPlugin annoyingPlugin;
    @NotNull
    private final String pluginName;
    @NotNull
    private final SemanticVersion currentVersion;
    @NotNull
    private final String userAgent;
    @NotNull
    private final PluginPlatform.Multi platforms;
    @Nullable
    public final SemanticVersion latestVersion;

    public AnnoyingUpdate(@NotNull AnnoyingPlugin annoyingPlugin, @NotNull PluginDescriptionFile pluginDescription, @NotNull PluginPlatform.Multi platforms) {
        this.annoyingPlugin = annoyingPlugin;
        this.pluginName = pluginDescription.getName();
        this.currentVersion = new SemanticVersion(pluginDescription.getVersion());
        this.userAgent = annoyingPlugin.getName() + "/" + annoyingPlugin.getDescription().getVersion() + " via Annoying API (update)";
        this.platforms = platforms;
        this.latestVersion = this.getLatestVersion().map(SemanticVersion::new).orElse(null);
    }

    public AnnoyingUpdate(@NotNull AnnoyingPlugin annoyingPlugin, @NotNull PluginBase plugin, @NotNull PluginPlatform.Multi platforms) {
        this(annoyingPlugin, plugin.getDescription(), platforms);
    }

    public AnnoyingUpdate(@NotNull AnnoyingPlugin plugin, @NotNull PluginPlatform.Multi platforms) {
        this(plugin, (PluginBase)plugin, platforms);
    }

    @Override
    @NotNull
    public AnnoyingPlugin getAnnoyingPlugin() {
        return this.annoyingPlugin;
    }

    public boolean checkUpdate() {
        boolean update = this.isUpdateAvailable();
        if (update && this.latestVersion != null) {
            new AnnoyingMessage(this.annoyingPlugin, this.annoyingPlugin.options.messagesOptions.keys.updateAvailable).replace("%plugin%", this.pluginName).replace("%current%", this.currentVersion.version).replace("%new%", this.latestVersion.version).log(Level.WARNING);
        }
        return update;
    }

    public boolean isUpdateAvailable() {
        return this.latestVersion != null && this.latestVersion.isGreaterThan(this.currentVersion);
    }

    @NotNull
    private Optional<String> getLatestVersion() {
        Optional<String> spigotIdentifier;
        Optional<PluginPlatform> hangarPlatform;
        Optional<String> modrinthIdentifier = this.platforms.getIdentifier(PluginPlatform.Platform.MODRINTH);
        if (modrinthIdentifier.isPresent()) {
            try {
                Optional<String> modrinth = this.modrinth(modrinthIdentifier.get());
                if (modrinth.isPresent()) {
                    return modrinth;
                }
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "Failed to check Modrinth for the latest version of " + this.pluginName, e);
                return this.fail(PluginPlatform.Platform.MODRINTH);
            }
        }
        if ((hangarPlatform = this.platforms.get(PluginPlatform.Platform.HANGAR)).isPresent()) {
            try {
                Optional<String> hangar = this.hangar(hangarPlatform.get());
                if (hangar.isPresent()) {
                    return hangar;
                }
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "Failed to check Hangar for the latest version of " + this.pluginName, e);
                return this.fail(PluginPlatform.Platform.HANGAR);
            }
        }
        if ((spigotIdentifier = this.platforms.getIdentifier(PluginPlatform.Platform.SPIGOT)).isPresent()) {
            try {
                Optional<String> spigot = this.spigot(spigotIdentifier.get());
                if (spigot.isPresent()) {
                    return spigot;
                }
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "Failed to check Spigot for the latest version of " + this.pluginName, e);
                return this.fail(PluginPlatform.Platform.SPIGOT);
            }
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<String> modrinth(@NotNull String identifier) {
        try {
            Optional<JsonArray> json = HttpUtility.getJson(this.userAgent, "https://api.modrinth.com/v2/project/" + identifier + "/version?loaders=%5B%22spigot%22,%22paper%22,%22purpur%22%5D&game_versions=%5B%22" + MINECRAFT_VERSION_SHORT + "%22%5D&include_changelog=false", null).map(JsonElement::getAsJsonArray);
            if (!json.isPresent()) {
                return this.fail(PluginPlatform.Platform.MODRINTH);
            }
            return json.get().size() != 0 ? json.map(versions -> versions.get(0).getAsJsonObject().get("version_number").getAsString()) : this.fail(PluginPlatform.Platform.MODRINTH);
        }
        catch (IllegalStateException e) {
            return this.fail(PluginPlatform.Platform.MODRINTH);
        }
    }

    @NotNull
    private Optional<String> hangar(@NotNull PluginPlatform platform) {
        Optional<JsonArray> json = HttpUtility.getJson(this.userAgent, "https://hangar.papermc.io/api/v1/projects/" + platform.author + "/" + platform.identifier + "/versions", null).map(element -> element.getAsJsonObject().getAsJsonArray("result"));
        if (!json.isPresent()) {
            return this.fail(PluginPlatform.Platform.HANGAR);
        }
        HashMap<String, OffsetDateTime> result = new HashMap<String, OffsetDateTime>();
        try {
            block2: for (JsonElement versionElement : json.get()) {
                JsonArray paper;
                JsonObject version = versionElement.getAsJsonObject();
                JsonObject platformsObject = version.getAsJsonObject("platformDependencies");
                if (platformsObject == null || (paper = platformsObject.getAsJsonArray("PAPER")) == null) continue;
                for (JsonElement paperElement : paper) {
                    String paperVersion = paperElement.getAsString();
                    if (!paperVersion.equals(MINECRAFT_VERSION_SHORT)) continue;
                    String name = version.get("name").getAsString();
                    OffsetDateTime createdAt = OffsetDateTime.parse(version.get("createdAt").getAsString());
                    OffsetDateTime existing = (OffsetDateTime)result.get(name);
                    if (existing != null) {
                        if (!createdAt.isAfter(existing)) continue block2;
                        result.put(name, createdAt);
                        continue block2;
                    }
                    result.put(name, createdAt);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            return this.fail(PluginPlatform.Platform.HANGAR);
        }
        Optional<String> latest = result.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
        return latest.isPresent() ? latest : this.fail(PluginPlatform.Platform.HANGAR);
    }

    @NotNull
    private Optional<String> spigot(@NotNull String identifier) {
        Optional<String> json = HttpUtility.getJson(this.userAgent, "https://api.spiget.org/v2/resources/" + identifier + "/versions/latest", null).map(element -> element.getAsJsonObject().get("name").getAsString());
        if (!json.isPresent()) {
            return this.fail(PluginPlatform.Platform.SPIGOT);
        }
        return json;
    }

    @NotNull
    private Optional<String> fail(@NotNull PluginPlatform.Platform platform) {
        this.platforms.remove(platform);
        return this.getLatestVersion();
    }
}

