/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.config;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.LimitedLives;
import xyz.srnyx.limitedlives.config.CraftingTrigger;
import xyz.srnyx.limitedlives.config.Feature;
import xyz.srnyx.limitedlives.config.GracePeriodTrigger;
import xyz.srnyx.limitedlives.config.KeepInventoryAction;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.data.ItemData;
import xyz.srnyx.limitedlives.libs.annoyingapi.file.AnnoyingResource;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.manipulation.Mapper;
import xyz.srnyx.limitedlives.libs.annoyingapi.reflection.org.bukkit.RefGameRule;
import xyz.srnyx.limitedlives.libs.annoyingapi.reflection.org.bukkit.RefWorld;

public class LimitedConfig {
    @NotNull
    private final AnnoyingResource config;
    @NotNull
    public final Lives lives;
    @NotNull
    public final Set<String> deathCauses;
    @NotNull
    public final KeepInventory keepInventory;
    @NotNull
    public final GracePeriod gracePeriod;
    @NotNull
    public final Commands commands;
    @NotNull
    public final Obtaining obtaining;
    @NotNull
    public final WorldsBlacklist worldsBlacklist;

    public LimitedConfig(@NotNull LimitedLives plugin) {
        this.config = new AnnoyingResource((AnnoyingPlugin)plugin, "config.yml");
        this.lives = new Lives();
        this.deathCauses = LimitedConfig.getDamageCauses(this.config.getStringList("death-causes"));
        this.keepInventory = new KeepInventory();
        this.gracePeriod = new GracePeriod();
        this.commands = new Commands();
        this.obtaining = new Obtaining();
        this.worldsBlacklist = new WorldsBlacklist();
    }

    @NotNull
    private static Set<String> getDamageCauses(@NotNull List<String> collection) {
        return collection.stream().map(String::toUpperCase).collect(Collectors.toSet());
    }

    public class Lives {
        public final int def;
        public final int max;
        public final int min;

        public Lives() {
            this.def = LimitedConfig.this.config.getInt("lives.default", 5);
            this.max = LimitedConfig.this.config.getInt("lives.max", 10);
            this.min = LimitedConfig.this.config.getInt("lives.min", 0);
        }
    }

    public class KeepInventory {
        public final boolean enabled;
        @NotNull
        public final Actions actions;

        public KeepInventory() {
            this.enabled = LimitedConfig.this.config.getBoolean("keep-inventory.enabled", false);
            this.actions = new Actions();
            if (this.enabled) {
                Bukkit.getWorlds().stream().filter(world -> {
                    String value = RefWorld.getGameRuleValue(world, "keepInventory", RefGameRule.GAME_RULE_KEEP_INVENTORY);
                    return value != null && value.equalsIgnoreCase("true");
                }).forEach(world -> {
                    AnnoyingPlugin.log(Level.WARNING, "keep_inventory is enabled in " + world.getName() + "! The plugin is disabling it to ensure the keep-inventory feature works properly");
                    RefWorld.setGameRuleValue(world, "keepInventory", RefGameRule.GAME_RULE_KEEP_INVENTORY, false);
                });
            }
        }

        public class Actions {
            @NotNull
            private final KeepInventoryAction def;
            @NotNull
            private final Map<Integer, KeepInventoryAction> exact = new HashMap<Integer, KeepInventoryAction>();

            public Actions() {
                this.def = Mapper.toEnum(LimitedConfig.this.config.getString("keep-inventory.actions.default"), KeepInventoryAction.class).orElse(KeepInventoryAction.KEEP);
                ConfigurationSection section = LimitedConfig.this.config.getConfigurationSection("keep-inventory.actions");
                if (section != null) {
                    for (String key : section.getKeys(false)) {
                        int count;
                        if (key.equals("default") || key.equals("first") || key.equals("last")) continue;
                        try {
                            count = Integer.parseInt(key);
                        }
                        catch (NumberFormatException e) {
                            AnnoyingPlugin.log(Level.WARNING, "Invalid keep inventory action count: " + key);
                            continue;
                        }
                        Mapper.toEnum(LimitedConfig.this.config.getString("keep-inventory.actions." + key), KeepInventoryAction.class).ifPresent(keepInventoryAction -> this.exact.put(count, (KeepInventoryAction)((Object)keepInventoryAction)));
                    }
                }
            }

            @NotNull
            public KeepInventoryAction getAction(int deaths) {
                KeepInventoryAction action = this.exact.get(deaths);
                return action != null ? action : this.def;
            }
        }
    }

    public class GracePeriod {
        public final boolean enabled;
        @NotNull
        public final Duration duration;
        @NotNull
        public final Set<GracePeriodTrigger> triggers;
        @NotNull
        public final Set<String> bypassCauses;
        @NotNull
        public final Set<String> disabledDamageCauses;

        public GracePeriod() {
            this.enabled = LimitedConfig.this.config.getBoolean("grace-period.enabled", false);
            this.duration = Duration.ofSeconds(LimitedConfig.this.config.getInt("grace-period.duration", 60));
            this.triggers = new HashSet<GracePeriodTrigger>();
            this.bypassCauses = LimitedConfig.getDamageCauses(LimitedConfig.this.config.getStringList("grace-period.bypass-causes"));
            this.disabledDamageCauses = LimitedConfig.getDamageCauses(LimitedConfig.this.config.getStringList("grace-period.disabled-damage-causes"));
            for (String string : LimitedConfig.this.config.getStringList("grace-period.triggers")) {
                Mapper.toEnum(string, GracePeriodTrigger.class).ifPresent(this.triggers::add);
            }
        }
    }

    public class Commands {
        @NotNull
        public final Punishment punishment = new Punishment();
        @NotNull
        public final List<String> revive = LimitedConfig.access$000(LimitedConfig.this).getStringList("commands.revive");

        public class Punishment {
            @NotNull
            private static final String COMMANDS_PUNISHMENT_RESPAWN = "commands.punishment.respawn";
            @NotNull
            public final List<String> death;
            @NotNull
            public final List<String> respawn;

            public Punishment() {
                this.death = LimitedConfig.this.config.getStringList("commands.punishment.death");
                this.respawn = LimitedConfig.this.config.getStringList(COMMANDS_PUNISHMENT_RESPAWN);
                if (AnnoyingPlugin.FOLIA && !this.respawn.isEmpty()) {
                    AnnoyingPlugin.log(Level.WARNING, "&c&lThe respawn punishment commands are not supported on Folia! &cPlease enable the doImmediateRespawn gamerule and use death commands instead.\n&c&oTo disable this message, set &4&ocommands.punishment.respawn&c&o to &4&o[]&c&o in &4&oconfig.yml");
                }
            }
        }
    }

    public class Obtaining {
        public final boolean stealing;
        @NotNull
        public final Crafting crafting;

        public Obtaining() {
            this.stealing = LimitedConfig.this.config.getBoolean("obtaining.stealing", true);
            this.crafting = new Crafting();
        }

        public class Crafting {
            @NotNull
            private static final String OBTAINING_CRAFTING_TRIGGERS = "obtaining.crafting.triggers";
            public final int amount;
            @NotNull
            public final Set<CraftingTrigger> triggers;
            @NotNull
            public final Duration cooldown;
            @Nullable
            public final Recipe recipe;

            public Crafting() {
                this.amount = LimitedConfig.this.config.getInt("obtaining.crafting.amount", 1);
                this.triggers = new HashSet<CraftingTrigger>();
                this.cooldown = Duration.ofMillis(LimitedConfig.this.config.getLong("obtaining.crafting.cooldown", 500L));
                Recipe recipe = this.recipe = LimitedConfig.this.config.getBoolean("obtaining.crafting.enabled", true) ? (Recipe)LimitedConfig.this.config.getRecipe("obtaining.crafting.recipe", item -> (ItemStack)new ItemData((AnnoyingPlugin)((LimitedConfig)LimitedConfig.this).config.plugin, (ItemStack)item).setChain((String)"ll_item", (Object)Boolean.valueOf((boolean)true)).target, "life").orElse(null) : null;
                if (LimitedConfig.this.config.isSet(OBTAINING_CRAFTING_TRIGGERS)) {
                    for (String string : LimitedConfig.this.config.getStringList(OBTAINING_CRAFTING_TRIGGERS)) {
                        Mapper.toEnum(string, CraftingTrigger.class).ifPresent(this.triggers::add);
                    }
                } else {
                    this.triggers.add(CraftingTrigger.CONSUME);
                }
            }
        }
    }

    public class WorldsBlacklist {
        @NotNull
        private static final String WORLDS_BLACKLIST_AFFECTED_FEATURES = "worlds-blacklist.affected-features";
        @NotNull
        public final Set<String> list;
        public final boolean actAsWhitelist;
        private final Set<Feature> affectedFeatures;

        public WorldsBlacklist() {
            this.list = LimitedConfig.this.config.getStringList("worlds-blacklist.list").stream().map(String::toLowerCase).collect(Collectors.toSet());
            this.actAsWhitelist = LimitedConfig.this.config.getBoolean("worlds-blacklist.act-as-whitelist", false);
            this.affectedFeatures = new HashSet<Feature>();
            if (LimitedConfig.this.config.isSet(WORLDS_BLACKLIST_AFFECTED_FEATURES)) {
                for (String string : LimitedConfig.this.config.getStringList(WORLDS_BLACKLIST_AFFECTED_FEATURES)) {
                    Mapper.toEnum(string, Feature.class).ifPresent(this.affectedFeatures::add);
                }
            } else {
                this.affectedFeatures.addAll(Arrays.asList(Feature.values()));
            }
        }

        public boolean isWorldEnabled(@NotNull World world, @NotNull Feature feature) {
            boolean inList = this.list.contains(world.getName().toLowerCase());
            boolean affectsFeature = this.affectedFeatures.contains((Object)feature);
            return this.actAsWhitelist ? inList && affectsFeature : !inList || !affectsFeature;
        }
    }
}

