/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.commands;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.LimitedLives;
import xyz.srnyx.limitedlives.config.Feature;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.AnnoyingCommand;
import xyz.srnyx.limitedlives.libs.annoyingapi.command.AnnoyingSender;
import xyz.srnyx.limitedlives.libs.annoyingapi.data.StringData;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.FileUtility;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.manipulation.Mapper;
import xyz.srnyx.limitedlives.libs.annoyingapi.message.AnnoyingMessage;
import xyz.srnyx.limitedlives.libs.annoyingapi.utility.BukkitUtility;
import xyz.srnyx.limitedlives.managers.player.PlayerManager;
import xyz.srnyx.limitedlives.managers.player.exception.ActionException;
import xyz.srnyx.limitedlives.managers.player.exception.LessThanMinLives;

public class LivesCmd
extends AnnoyingCommand {
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private final LimitedLives plugin;
    @NotNull
    private static final List<String> NO_ARGS = Arrays.asList("get", "set", "add", "remove", "give", "withdraw", "convert");

    public LivesCmd(@NotNull LimitedLives plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public LimitedLives getAnnoyingPlugin() {
        return this.plugin;
    }

    @Override
    public void onCommand(@NotNull AnnoyingSender sender) {
        int newLives;
        World world;
        if (sender.isPlayer && !this.plugin.config.worldsBlacklist.isWorldEnabled(world = sender.getPlayer().getWorld(), Feature.COMMANDS)) {
            new AnnoyingMessage(this.plugin, "feature-disabled").replace("%feature%", (Object)Feature.COMMANDS).replace("%world%", world.getName()).send(sender);
            return;
        }
        int length = sender.args.length;
        if (length == 0 || length == 1 && sender.argEquals(0, "get")) {
            if (sender.checkPlayer() && sender.checkPermission("limitedlives.get.self")) {
                new AnnoyingMessage(this.plugin, "get.self").replace("%lives%", new PlayerManager(this.plugin, (OfflinePlayer)sender.getPlayer()).getLives()).send(sender);
            }
            return;
        }
        if (length < 2) {
            sender.invalidArguments();
            return;
        }
        if (sender.argEquals(0, "convert")) {
            if (!sender.checkPermission("limitedlives.convert")) {
                return;
            }
            if (!sender.argEquals(1, "hardcorelivesplugin")) {
                sender.invalidArgumentByIndex(1);
                return;
            }
            int succeeded = 0;
            int failed = 0;
            File playersFolder = new File(this.plugin.getDataFolder().getParentFile(), "Hardcorelivesplugin/players");
            for (String uuidString : FileUtility.getFileNames(playersFolder, "json")) {
                int lives;
                JsonObject json;
                try {
                    json = (JsonObject)GSON.fromJson((Reader)new FileReader(new File(playersFolder, uuidString + ".json")), JsonObject.class);
                }
                catch (FileNotFoundException e) {
                    AnnoyingPlugin.log(Level.WARNING, "Failed to convert Hardcore Lives Plugin data for " + uuidString + ", file not found", e);
                    ++failed;
                    continue;
                }
                JsonElement livesElement = json.get("lives");
                if (livesElement == null) {
                    AnnoyingPlugin.log(Level.WARNING, "Failed to convert Hardcore Lives Plugin data for " + uuidString + ", lives not found");
                    ++failed;
                    continue;
                }
                try {
                    lives = livesElement.getAsInt();
                }
                catch (ClassCastException e) {
                    AnnoyingPlugin.log(Level.WARNING, "Failed to convert Hardcore Lives Plugin data for " + uuidString + ", lives not an integer", e);
                    ++failed;
                    continue;
                }
                if (!new StringData(this.plugin, "entities", uuidString).set("ll_lives", lives)) {
                    AnnoyingPlugin.log(Level.WARNING, "Failed to convert Hardcore Lives Plugin data for " + uuidString + ", failed to save");
                    ++failed;
                    continue;
                }
                AnnoyingPlugin.log(Level.INFO, "Converted Hardcore Lives Plugin data for " + uuidString + " with " + lives + " lives");
                ++succeeded;
            }
            new AnnoyingMessage(this.plugin, "convert").replace("%source%", "HardcoreLivesPlugin").replace("%succeeded%", succeeded).replace("%failed%", failed).send(sender);
            return;
        }
        if (sender.argEquals(0, "get")) {
            if (!sender.checkPermission("limitedlives.get.other")) {
                return;
            }
            List<OfflinePlayer> players = sender.getSelector(1, OfflinePlayer.class).orElseFlatSingle(BukkitUtility::getOfflinePlayer);
            if (players != null) {
                for (OfflinePlayer player : players) {
                    new AnnoyingMessage(this.plugin, "get.other").replace("%target%", player.getName()).replace("%lives%", new PlayerManager(this.plugin, player).getLives()).send(sender);
                }
            }
            return;
        }
        Integer lives = sender.getArgumentOptionalFlat(1, Mapper::toInt).orElse(null);
        if (lives == null) {
            return;
        }
        if (length == 2) {
            int newLives2;
            if (!sender.checkPlayer()) {
                return;
            }
            String action = sender.getArgument(0, String::toLowerCase);
            if (action == null || !sender.checkPermission("limitedlives." + action + ".self")) {
                return;
            }
            Player player = sender.getPlayer();
            String playerName = player.getName();
            PlayerManager manager = new PlayerManager(this.plugin, (OfflinePlayer)player);
            try {
                switch (action) {
                    case "set": {
                        newLives2 = manager.setLives(lives);
                        break;
                    }
                    case "add": {
                        newLives2 = manager.addLives(lives);
                        break;
                    }
                    case "remove": {
                        newLives2 = manager.removeLives(lives, null);
                        break;
                    }
                    case "withdraw": {
                        if (lives <= 0) {
                            new AnnoyingMessage(this.plugin, "withdraw.negative").send(sender);
                            return;
                        }
                        int currentLives = manager.getLives();
                        if (currentLives <= lives) {
                            lives = currentLives - 1;
                        }
                        if (lives <= this.plugin.config.lives.min) {
                            throw new LessThanMinLives();
                        }
                        newLives2 = manager.withdrawLives(player, lives);
                        break;
                    }
                    default: {
                        sender.invalidArgumentByIndex(0);
                        return;
                    }
                }
            }
            catch (ActionException e) {
                new AnnoyingMessage(this.plugin, action + "." + e.getMessageKey()).replace("%amount%", lives).replace("%target%", playerName).replace("%min%", this.plugin.config.lives.min).replace("%max%", manager.getMaxLives()).send(sender);
                return;
            }
            new AnnoyingMessage(this.plugin, action + ".self").replace("%amount%", lives).replace("%lives%", newLives2).send(sender);
            return;
        }
        if (length != 3) {
            sender.invalidArguments();
            return;
        }
        if (sender.argEquals(0, "give")) {
            int newTargetLives;
            int newPlayerLives;
            int targetLives;
            if (!sender.checkPlayer() || !sender.checkPermission("limitedlives.give")) {
                return;
            }
            if (lives <= 0) {
                new AnnoyingMessage(this.plugin, "give.negative").send(sender);
                return;
            }
            OfflinePlayer target = sender.getArgumentOptionalFlat(2, BukkitUtility::getOfflinePlayer).orElse(null);
            if (target == null) {
                return;
            }
            Player player = sender.getPlayer();
            if (target.getUniqueId().equals(player.getUniqueId())) {
                new AnnoyingMessage(this.plugin, "give.self").send(sender);
                return;
            }
            PlayerManager playerManager = new PlayerManager(this.plugin, (OfflinePlayer)player);
            PlayerManager targetManager = new PlayerManager(this.plugin, target);
            int playerLives = playerManager.getLives();
            if (playerLives <= this.plugin.config.lives.min + 1) {
                new AnnoyingMessage(this.plugin, "give.last-life").send(sender);
                return;
            }
            if (playerLives <= lives) {
                lives = playerLives - 1;
            }
            if ((targetLives = targetManager.getLives()) + lives > targetManager.getMaxLives()) {
                lives = this.plugin.config.lives.max - targetLives;
            }
            try {
                newPlayerLives = playerManager.removeLives(lives, null);
                newTargetLives = targetManager.addLives(lives);
            }
            catch (ActionException e) {
                sender.invalidArguments();
                return;
            }
            String playerName = player.getName();
            String targetName = target.getName();
            new AnnoyingMessage(this.plugin, "give.player").replace("%player%", playerName).replace("%target%", targetName).replace("%playerlives%", newPlayerLives).replace("%targetlives%", newTargetLives).replace("%amount%", lives).send(sender);
            if (target instanceof Player) {
                new AnnoyingMessage(this.plugin, "give.target").replace("%player%", playerName).replace("%target%", targetName).replace("%playerlives%", newPlayerLives).replace("%targetlives%", newTargetLives).replace("%amount%", lives).send((CommandSender)((Player)target));
            }
            return;
        }
        String action = sender.getArgument(0, String::toLowerCase);
        if (action == null || !sender.checkPermission("limitedlives." + action + ".other")) {
            return;
        }
        OfflinePlayer target = sender.getArgumentOptionalFlat(2, BukkitUtility::getOfflinePlayer).orElse(null);
        if (target == null) {
            return;
        }
        String targetName = target.getName();
        PlayerManager manager = new PlayerManager(this.plugin, target);
        try {
            switch (action) {
                case "set": {
                    newLives = manager.setLives(lives);
                    break;
                }
                case "add": {
                    newLives = manager.addLives(lives);
                    break;
                }
                case "remove": {
                    newLives = manager.removeLives(lives, null);
                    break;
                }
                case "withdraw": {
                    if (!sender.checkPlayer()) {
                        return;
                    }
                    if (lives <= 0) {
                        new AnnoyingMessage(this.plugin, "withdraw.negative").send(sender);
                        return;
                    }
                    int currentLives = manager.getLives();
                    if (currentLives <= lives) {
                        lives = currentLives - 1;
                    }
                    if (lives <= this.plugin.config.lives.min) {
                        throw new LessThanMinLives();
                    }
                    newLives = manager.withdrawLives(sender.getPlayer(), lives);
                    break;
                }
                default: {
                    sender.invalidArgumentByIndex(0);
                    return;
                }
            }
        }
        catch (ActionException e) {
            new AnnoyingMessage(this.plugin, action + "." + e.getMessageKey()).replace("%amount%", lives).replace("%target%", targetName).replace("%min%", this.plugin.config.lives.min).replace("%max%", manager.getMaxLives()).send(sender);
            return;
        }
        new AnnoyingMessage(this.plugin, action + ".other").replace("%amount%", lives).replace("%target%", target.getName()).replace("%lives%", newLives).send(sender);
    }

    @Override
    @Nullable
    public Collection<String> onTabComplete(@NotNull AnnoyingSender sender) {
        if (!this.plugin.config.worldsBlacklist.isWorldEnabled(sender.getPlayer().getWorld(), Feature.COMMANDS)) {
            return null;
        }
        String[] args = sender.args;
        int length = args.length;
        if (length == 1) {
            return NO_ARGS;
        }
        CommandSender cmdSender = sender.cmdSender;
        if (length == 2) {
            if (sender.argEquals(0, "convert")) {
                if (cmdSender.hasPermission("limitedlives.convert")) {
                    return Collections.singleton("hardcorelivesplugin");
                }
                return null;
            }
            if (sender.argEquals(0, "get")) {
                if (cmdSender.hasPermission("limitedlives.get.other")) {
                    return this.plugin.selectorManager.withKeys(BukkitUtility.getOnlinePlayerNames(), OfflinePlayer.class);
                }
                if (cmdSender.hasPermission("limitedlives.get.self")) {
                    return Collections.singleton(cmdSender.getName());
                }
                return null;
            }
            if (sender.argEquals(0, "set", "add", "remove", "withdraw", "give")) {
                return Collections.singleton("[<lives>]");
            }
            return null;
        }
        if (length == 3) {
            String actionLower = sender.getArgumentOptional(0).map(String::toLowerCase).orElse(null);
            if (actionLower == null || actionLower.equals("get")) {
                return null;
            }
            if (cmdSender.hasPermission("limitedlives." + actionLower + ".other")) {
                return this.plugin.selectorManager.withKeys(BukkitUtility.getOnlinePlayerNames(), OfflinePlayer.class);
            }
            if (cmdSender.hasPermission("limitedlives." + actionLower + ".self")) {
                return Collections.singleton(cmdSender.getName());
            }
        }
        return null;
    }
}

