/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.managers.player;

import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.LimitedLives;
import xyz.srnyx.limitedlives.config.GracePeriodTrigger;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.data.StringData;
import xyz.srnyx.limitedlives.libs.annoyingapi.utility.BukkitUtility;
import xyz.srnyx.limitedlives.managers.player.exception.LessThanMinLives;
import xyz.srnyx.limitedlives.managers.player.exception.MoreThanMaxLives;
import xyz.srnyx.limitedlives.managers.player.exception.RecipeNotSet;

public class PlayerManager {
    @NotNull
    public static final String LIVES_KEY = "ll_lives";
    @NotNull
    public static final String DEAD_KEY = "ll_dead";
    @NotNull
    public static final String GRACE_START_KEY = "grace_start";
    @NotNull
    public static final String ITEM_KEY = "ll_item";
    @NotNull
    private final LimitedLives plugin;
    @NotNull
    private final OfflinePlayer offline;
    @NotNull
    private final StringData data;

    public PlayerManager(@NotNull LimitedLives plugin, @NotNull OfflinePlayer offline) {
        this.plugin = plugin;
        this.offline = offline;
        this.data = new StringData((AnnoyingPlugin)plugin, offline);
    }

    public int getLives() {
        String livesString = this.data.get(LIVES_KEY);
        if (livesString != null) {
            try {
                return Integer.parseInt(livesString);
            }
            catch (NumberFormatException e) {
                AnnoyingPlugin.log(Level.WARNING, "&cRemoving invalid lives from &4" + this.offline.getName() + "&c: &4" + livesString);
                this.data.remove(LIVES_KEY);
            }
        }
        return this.plugin.config.lives.def;
    }

    public int getMaxLives() {
        Player online = this.offline.getPlayer();
        if (online == null) {
            return this.plugin.config.lives.max;
        }
        return BukkitUtility.getPermissionValue(online, "limitedlives.max.").map(Long::intValue).orElse(this.plugin.config.lives.max);
    }

    public int getDeaths() {
        return this.getMaxLives() - this.getLives();
    }

    public long getGraceLeft() {
        long graceLeft;
        if (!this.plugin.config.gracePeriod.enabled) {
            return 0L;
        }
        String graceStart = this.data.get(GRACE_START_KEY);
        if (graceStart == null) {
            return 0L;
        }
        try {
            graceLeft = this.plugin.config.gracePeriod.duration.toMillis() - (System.currentTimeMillis() - Long.parseLong(graceStart));
        }
        catch (NumberFormatException e) {
            AnnoyingPlugin.log(Level.WARNING, "&cRemoved invalid grace_start value for &4" + this.offline.getName() + "&c: &4" + graceStart, e);
            this.data.remove(GRACE_START_KEY);
            return 0L;
        }
        if (graceLeft <= 0L) {
            this.data.remove(GRACE_START_KEY);
            return 0L;
        }
        return graceLeft;
    }

    public boolean hasGrace() {
        return this.getGraceLeft() > 0L;
    }

    public int setLives(int amount) throws LessThanMinLives, MoreThanMaxLives {
        if (amount < this.plugin.config.lives.min) {
            throw new LessThanMinLives();
        }
        if (amount > this.getMaxLives()) {
            throw new MoreThanMaxLives();
        }
        int oldLives = this.getLives();
        this.data.set(LIVES_KEY, amount);
        if (oldLives <= this.plugin.config.lives.min && amount > this.plugin.config.lives.min) {
            this.revive();
        }
        if (amount == this.plugin.config.lives.min) {
            this.kill(null);
        }
        return amount;
    }

    public int addLives(int amount) throws MoreThanMaxLives {
        int oldLives = this.getLives();
        int newLives = oldLives + amount;
        if (newLives > this.getMaxLives()) {
            throw new MoreThanMaxLives();
        }
        this.data.set(LIVES_KEY, newLives);
        if (oldLives <= this.plugin.config.lives.min && newLives > this.plugin.config.lives.min) {
            this.revive();
        }
        return newLives;
    }

    public int removeLives(int amount, @Nullable Player killer) throws LessThanMinLives {
        int newLives = this.getLives() - amount;
        if (newLives < this.plugin.config.lives.min) {
            throw new LessThanMinLives();
        }
        this.data.set(LIVES_KEY, newLives);
        if (newLives == this.plugin.config.lives.min) {
            this.kill(killer);
        }
        return newLives;
    }

    public int withdrawLives(@NotNull Player sender, int amount) throws LessThanMinLives, RecipeNotSet {
        if (this.plugin.config.obtaining.crafting.recipe == null) {
            throw new RecipeNotSet();
        }
        ItemStack item = this.plugin.config.obtaining.crafting.recipe.getResult();
        item.setAmount(amount);
        sender.getInventory().addItem(new ItemStack[]{item});
        return this.removeLives(amount, null);
    }

    private void revive() {
        this.data.remove(DEAD_KEY);
        if (this.plugin.config.gracePeriod.triggers.contains((Object)GracePeriodTrigger.REVIVE)) {
            this.data.set(GRACE_START_KEY, System.currentTimeMillis());
        }
        this.dispatchCommands(this.plugin.config.commands.revive, null);
    }

    private void kill(@Nullable Player killer) {
        this.data.set(DEAD_KEY, (Object)(killer != null ? killer.getUniqueId().toString() : "null"));
        this.dispatchCommands(this.plugin.config.commands.punishment.death, (OfflinePlayer)killer);
    }

    public void dispatchCommands(@NotNull List<String> commands, @Nullable OfflinePlayer killer) {
        this.plugin.scheduler.runSync(() -> {
            for (String command : commands) {
                if (command.contains("%killer%")) {
                    if (killer == null) continue;
                    command = command.replace("%killer%", killer.getName());
                }
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", this.offline.getName()));
            }
        });
    }
}

