/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.listeners;

import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.limitedlives.LimitedLives;
import xyz.srnyx.limitedlives.config.Feature;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingListener;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.annoyingapi.data.ItemData;
import xyz.srnyx.limitedlives.libs.annoyingapi.message.AnnoyingMessage;

public class CraftListener
extends AnnoyingListener {
    @NotNull
    private final LimitedLives plugin;

    public CraftListener(@NotNull LimitedLives plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public LimitedLives getAnnoyingPlugin() {
        return this.plugin;
    }

    @EventHandler
    public void onPrepareItemCraft(@NotNull PrepareItemCraftEvent event) {
        HumanEntity player = event.getView().getPlayer();
        World world = player.getWorld();
        Recipe recipe = event.getRecipe();
        if (recipe == null || this.plugin.config.worldsBlacklist.isWorldEnabled(world, Feature.OBTAINING_CRAFTING) || new ItemData((AnnoyingPlugin)this.plugin, recipe.getResult()).get("ll_item") == null) {
            return;
        }
        new AnnoyingMessage(this.plugin, "feature-disabled").replace("%feature%", (Object)Feature.OBTAINING_CRAFTING).replace("%world%", world.getName()).send((CommandSender)player);
        event.getInventory().setResult(null);
    }
}

