/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.manipulation;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.limitedlives.libs.annoyingapi.libs.javautilities.MiscUtility;

public class Mapper {
    @NotNull
    public static <T> Optional<T> to(@Nullable Object object, @NotNull Class<T> clazz) {
        return !clazz.isInstance(object) ? Optional.empty() : MiscUtility.handleException(() -> clazz.cast(object), ClassCastException.class);
    }

    @NotNull
    public static Optional<Integer> toInt(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> Integer.parseInt(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<Double> toDouble(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> Double.parseDouble(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<Long> toLong(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> Long.parseLong(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<Float> toFloat(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> Float.valueOf(Float.parseFloat(object.toString())), NumberFormatException.class);
    }

    @NotNull
    public static Optional<Short> toShort(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> Short.parseShort(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<Byte> toByte(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> Byte.parseByte(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<BigInteger> toBigInteger(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> new BigInteger(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<BigDecimal> toBigDecimal(@Nullable Object object) {
        return object == null ? Optional.empty() : MiscUtility.handleException(() -> new BigDecimal(object.toString()), NumberFormatException.class);
    }

    @NotNull
    public static Optional<UUID> toUUID(@Nullable Object object) {
        if (object == null) {
            return Optional.empty();
        }
        String string = object.toString();
        if (!string.contains("-")) {
            if (string.length() != 32) {
                return Optional.empty();
            }
            try {
                string = string.substring(0, 8) + "-" + string.substring(8, 12) + "-" + string.substring(12, 16) + "-" + string.substring(16, 20) + "-" + string.substring(20);
            }
            catch (IndexOutOfBoundsException e) {
                return Optional.empty();
            }
        }
        String finalString = string;
        return MiscUtility.handleException(() -> UUID.fromString(finalString), IllegalArgumentException.class);
    }

    @NotNull
    public static <T extends Enum<T>> Optional<T> toEnum(@Nullable String name, @NotNull Class<T> enumClass) {
        return name == null || name.isEmpty() ? Optional.empty() : MiscUtility.handleException(() -> Enum.valueOf(enumClass, name.toUpperCase()), IllegalArgumentException.class);
    }

    @NotNull
    public static Optional<JsonElement> toJson(@Nullable Object object) {
        if (object == null) {
            return Optional.of(JsonNull.INSTANCE);
        }
        if (object instanceof JsonElement) {
            return Optional.of((JsonElement)object);
        }
        return MiscUtility.handleException(() -> MiscUtility.JSON_PARSER.parse(object.toString()), IllegalStateException.class);
    }

    @NotNull
    public static <T extends JsonElement> Optional<T> convertJsonElement(@Nullable JsonElement element, @NotNull Class<T> jsonClass) {
        return !jsonClass.isInstance(element) ? Optional.empty() : Optional.of((JsonElement)jsonClass.cast(element));
    }

    @NotNull
    public static <T> Optional<T> convertJsonPrimitive(@Nullable JsonPrimitive primitive, @NotNull Class<T> primitiveClass) {
        if (primitive == null || primitiveClass != Boolean.class && primitiveClass != Number.class && primitiveClass != String.class && primitiveClass != Double.class && primitiveClass != BigDecimal.class && primitiveClass != BigInteger.class && primitiveClass != Float.class && primitiveClass != Long.class && primitiveClass != Short.class && primitiveClass != Integer.class && primitiveClass != Byte.class && primitiveClass != Character.class) {
            return Optional.empty();
        }
        return MiscUtility.handleException(() -> {
            if (primitiveClass == Boolean.class) {
                return Boolean.valueOf(primitive.getAsBoolean());
            }
            if (primitiveClass == Number.class) {
                return primitive.getAsNumber();
            }
            if (primitiveClass == String.class) {
                return primitive.getAsString();
            }
            if (primitiveClass == Double.class) {
                return Double.valueOf(primitive.getAsDouble());
            }
            if (primitiveClass == BigDecimal.class) {
                return primitive.getAsBigDecimal();
            }
            if (primitiveClass == BigInteger.class) {
                return primitive.getAsBigInteger();
            }
            if (primitiveClass == Float.class) {
                return Float.valueOf(primitive.getAsFloat());
            }
            if (primitiveClass == Long.class) {
                return Long.valueOf(primitive.getAsLong());
            }
            if (primitiveClass == Short.class) {
                return Short.valueOf(primitive.getAsShort());
            }
            if (primitiveClass == Integer.class) {
                return Integer.valueOf(primitive.getAsInt());
            }
            if (primitiveClass == Byte.class) {
                return Byte.valueOf(primitive.getAsByte());
            }
            return Character.valueOf(primitive.getAsCharacter());
        }, IllegalStateException.class).map(primitiveClass::cast);
    }

    private Mapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

