/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.limitedlives.libs.annoyingapi;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import xyz.srnyx.limitedlives.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.limitedlives.libs.javassist.bytecode.ClassFile;
import xyz.srnyx.limitedlives.libs.reflections.ReflectionUtils;
import xyz.srnyx.limitedlives.libs.reflections.ReflectionsException;
import xyz.srnyx.limitedlives.libs.reflections.Store;
import xyz.srnyx.limitedlives.libs.reflections.scanners.Scanners;
import xyz.srnyx.limitedlives.libs.reflections.util.ClasspathHelper;
import xyz.srnyx.limitedlives.libs.reflections.util.NameHelper;
import xyz.srnyx.limitedlives.libs.reflections.vfs.Vfs;

public class AnnoyingReflections
implements NameHelper {
    protected AnnoyingReflections() {
    }

    @NotNull
    public static <T> Set<Class<? extends T>> getSubTypesOf(@NotNull Set<String> packages, @NotNull Class<T> type) {
        return Scanners.SubTypes.of(new AnnotatedElement[]{type}).as(Class.class, new ClassLoader[0]).apply((Object)new AnnoyingReflections().getStore(packages));
    }

    @NotNull
    private Store getStore(@NotNull Set<String> packages) {
        HashMap<String, Set<String>> storeMap = new HashMap<String, Set<String>>();
        Set patterns = packages.stream().map(pkg -> {
            if (!pkg.endsWith(".")) {
                pkg = pkg + ".";
            }
            return Pattern.compile(pkg.replace(".", "\\.").replace("$", "\\$") + ".*");
        }).collect(Collectors.toSet());
        Predicate<String> filter = string -> {
            if (!string.endsWith(".class")) {
                return false;
            }
            for (Pattern pattern : patterns) {
                if (!pattern.matcher((CharSequence)string).matches()) continue;
                return true;
            }
            return false;
        };
        ((Stream)packages.stream().map(x$0 -> ClasspathHelper.forPackage((String)x$0, (ClassLoader[])new ClassLoader[0])).flatMap(Collection::stream).parallel()).forEach(url -> {
            try (Vfs.Dir dir = null;){
                dir = Vfs.fromURL((URL)url);
                for (Vfs.File file : dir.getFiles()) {
                    String path = file.getRelativePath();
                    if (!filter.test(path) && !filter.test(path.replace('/', '.'))) continue;
                    try {
                        List entries = Scanners.SubTypes.scan(file);
                        if (entries == null) {
                            entries = Scanners.SubTypes.scan(AnnoyingReflections.getClassFile(file));
                        }
                        if (entries == null) continue;
                        for (Map.Entry entry : entries) {
                            String key = (String)entry.getKey();
                            if (key == null) continue;
                            HashSet<String> values = (HashSet<String>)storeMap.get(key);
                            if (values == null) {
                                values = new HashSet<String>();
                            }
                            values.add((String)entry.getValue());
                            storeMap.put(key, values);
                        }
                    }
                    catch (Exception e) {
                        AnnoyingPlugin.log(Level.WARNING, "Could not scan file " + file.getRelativePath(), e);
                    }
                }
            }
        });
        if (!storeMap.isEmpty()) {
            LinkedHashSet subTypesKeys = new LinkedHashSet(storeMap.keySet());
            subTypesKeys.removeAll(storeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
            subTypesKeys.remove("java.lang.Object");
            for (String key : subTypesKeys) {
                Class type = this.forClass(key, new ClassLoader[0]);
                if (type == null) continue;
                AnnoyingReflections.expandSupertypes(storeMap, key, type);
            }
        }
        HashMap<String, HashMap<String, Set<String>>> finalMap = new HashMap<String, HashMap<String, Set<String>>>();
        finalMap.put(Scanners.SubTypes.index(), storeMap);
        return new Store(finalMap);
    }

    @NotNull
    @Contract(value="_ -> new")
    private static ClassFile getClassFile(@NotNull Vfs.File file) {
        ClassFile classFile;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(file.openInputStream()));
        try {
            classFile = new ClassFile(dis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ReflectionsException("Could not create class object from file " + file.getRelativePath(), (Throwable)e);
            }
        }
        dis.close();
        return classFile;
    }

    private static void expandSupertypes(@NotNull Map<String, Set<String>> subTypesStore, @NotNull String key, @NotNull Class<?> type) {
        for (Class supertype : ReflectionUtils.getSuperTypes(type)) {
            String supertypeName = supertype.getName();
            if (subTypesStore.containsKey(supertypeName)) {
                subTypesStore.get(supertypeName).add(key);
                continue;
            }
            subTypesStore.computeIfAbsent(supertypeName, s -> new HashSet()).add(key);
            AnnoyingReflections.expandSupertypes(subTypesStore, supertypeName, supertype);
        }
    }
}

