/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.listeners;

import com.srnyx.commandlogger.CommandLogger;
import com.srnyx.commandlogger.InfoForVariables;
import com.srnyx.commandlogger.config.ConfigLogger;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingListener;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerCommandListener
extends AnnoyingListener {
    @NotNull
    private final CommandLogger plugin;

    public PlayerCommandListener(@NotNull CommandLogger plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public CommandLogger getAnnoyingPlugin() {
        return this.plugin;
    }

    @EventHandler
    public void onPlayerCommandPreprocess(@NotNull PlayerCommandPreprocessEvent event) {
        if (!this.plugin.config.players.enabled) {
            this.unregister();
            return;
        }
        String command = event.getMessage().substring(1);
        if (this.plugin.config.filters != null && this.plugin.config.filters.doesNotPass(command)) {
            return;
        }
        if (this.plugin.config.players.filters != null && this.plugin.config.players.filters.doesNotPass(command)) {
            return;
        }
        InfoForVariables info = new InfoForVariables(event);
        for (ConfigLogger logger : this.plugin.config.loggers) {
            if (logger.filters != null && logger.filters.doesNotPass(command)) {
                return;
            }
            try {
                Path file = logger.filePath(info);
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, logger.format(info).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to combined command log file for a player command!", e);
            }
        }
        Player player = event.getPlayer();
        String name = player.getName();
        for (ConfigLogger.PlayerLogger split : this.plugin.config.players.loggers) {
            if (split.filters != null && split.filters.doesNotPass(command) || !split.hasRequiredPermission(player)) continue;
            try {
                Path file = split.filePath(info);
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, split.format(info).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to player command log file for " + name + "!", e);
            }
        }
    }
}

