/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.listeners;

import com.srnyx.commandlogger.CommandLogger;
import com.srnyx.commandlogger.InfoForVariables;
import com.srnyx.commandlogger.config.ConfigLogger;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingListener;
import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import org.bukkit.event.EventHandler;
import org.bukkit.event.server.ServerCommandEvent;
import org.jetbrains.annotations.NotNull;

public class ConsoleCommandListener
extends AnnoyingListener {
    @NotNull
    private final CommandLogger plugin;

    public ConsoleCommandListener(@NotNull CommandLogger plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public CommandLogger getAnnoyingPlugin() {
        return this.plugin;
    }

    @EventHandler
    public void onServerCommand(@NotNull ServerCommandEvent event) {
        Path file;
        if (!this.plugin.config.console.enabled) {
            this.unregister();
            return;
        }
        String command = event.getCommand();
        if (this.plugin.config.filters != null && this.plugin.config.filters.doesNotPass(command)) {
            return;
        }
        if (this.plugin.config.console.filters != null && this.plugin.config.console.filters.doesNotPass(command)) {
            return;
        }
        InfoForVariables info = new InfoForVariables(event);
        for (ConfigLogger logger : this.plugin.config.loggers) {
            if (logger.filters != null && logger.filters.doesNotPass(command)) {
                return;
            }
            try {
                file = logger.filePath(info);
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, logger.format(info).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to combined command log file for a console command!", e);
            }
        }
        for (ConfigLogger logger : this.plugin.config.console.loggers) {
            if (logger.filters != null && logger.filters.doesNotPass(command)) continue;
            try {
                file = logger.filePath(info);
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.write(file, logger.format(info).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (Exception e) {
                AnnoyingPlugin.log(Level.WARNING, "&cFailed to write to console command log file!", e);
            }
        }
    }
}

