/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.storage;

import com.srnyx.commandlogger.libs.annoyingapi.AnnoyingPlugin;
import com.srnyx.commandlogger.libs.annoyingapi.file.AnnoyingFile;
import com.srnyx.commandlogger.libs.annoyingapi.scheduler.TaskWrapper;
import com.srnyx.commandlogger.libs.annoyingapi.storage.ConnectionException;
import com.srnyx.commandlogger.libs.annoyingapi.storage.FailedSet;
import com.srnyx.commandlogger.libs.annoyingapi.storage.StorageConfig;
import com.srnyx.commandlogger.libs.annoyingapi.storage.dialects.Dialect;
import com.srnyx.commandlogger.libs.annoyingapi.storage.dialects.sql.SQLDialect;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.SQLException;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataManager {
    @NotNull
    public final AnnoyingPlugin plugin;
    @NotNull
    public final StorageConfig storageConfig;
    @NotNull
    public final Dialect dialect;
    @NotNull
    public final String tablePrefix;
    @Nullable
    public TaskWrapper cacheSavingTask;

    public DataManager(@NotNull StorageConfig config) throws ConnectionException {
        this.plugin = config.file.plugin;
        this.storageConfig = config;
        this.dialect = this.storageConfig.method.dialect.apply(this);
        this.tablePrefix = this.storageConfig.remoteConnection != null ? this.storageConfig.remoteConnection.tablePrefix : "";
    }

    @NotNull
    public String getTableName(@NotNull String tableName) {
        return this.tablePrefix + tableName.toLowerCase();
    }

    public void toggleIntervalCacheSaving() {
        if (this.cacheSavingTask != null) {
            this.cacheSavingTask.cancel();
        }
        if (!this.storageConfig.cache.saveOn.contains((Object)StorageConfig.SaveOn.INTERVAL)) {
            this.cacheSavingTask = null;
            return;
        }
        this.cacheSavingTask = this.plugin.scheduler.runGlobalTaskTimerAsync(this.dialect::saveCache, this.storageConfig.cache.interval, this.storageConfig.cache.interval);
    }

    @NotNull
    public DataManager attemptDatabaseMigration() {
        File storage;
        File storageOld;
        DataManager newManager;
        File dataFolder = this.plugin.getDataFolder();
        File storageNew = new File(dataFolder, "storage-new.yml");
        if (!storageNew.exists()) {
            return this;
        }
        AnnoyingFile storageNewFile = new AnnoyingFile(this.plugin, storageNew, (AnnoyingFile.Options<?>)new AnnoyingFile.Options().canBeEmpty(false));
        if (!storageNewFile.load()) {
            return this;
        }
        StorageConfig storageNewConfig = new StorageConfig(storageNewFile);
        AnnoyingPlugin.log(Level.WARNING, "&aSuccessfully found &2storage-new.yml&a, attempting to migrate data from &2" + (Object)((Object)this.storageConfig.method) + "&a to &2" + (Object)((Object)storageNewConfig.method) + "&a...");
        try {
            newManager = new DataManager(storageNewConfig);
        }
        catch (ConnectionException e) {
            AnnoyingPlugin.log(Level.SEVERE, "&4storage-new.yml &8|&c Failed to connect to database! URL: '&4" + e.url + "&c' Properties: &4" + e.getPropertiesRedacted(), e);
            return this;
        }
        Dialect.MigrationData migrationData = this.dialect.getMigrationDataFromDatabase(newManager).orElse(null);
        if (migrationData == null) {
            return this;
        }
        if (!migrationData.data.isEmpty()) {
            if (newManager.dialect instanceof SQLDialect) {
                ((SQLDialect)newManager.dialect).createTablesKeys(migrationData.tablesKeys);
            }
            for (FailedSet failure : newManager.dialect.setToDatabase(migrationData.data)) {
                AnnoyingPlugin.log(Level.SEVERE, this.storageConfig.migrationLogPrefix + "Failed to set &4" + failure.column + "&c for &4" + failure.target + "&c in table &4" + failure.table + "&c to &4" + failure.value, failure.exception);
            }
        } else {
            AnnoyingPlugin.log(Level.SEVERE, this.storageConfig.migrationLogPrefix + "Found no data to migrate! This may or may not be an error...");
        }
        if (this.dialect instanceof SQLDialect) {
            try {
                ((SQLDialect)this.dialect).connection.close();
            }
            catch (SQLException e) {
                AnnoyingPlugin.log(Level.SEVERE, "&cFailed to close the old database connection, it's recommended to restart the server!", e);
            }
        }
        if ((storageOld = new File(dataFolder, "storage-old.yml")).exists()) {
            try {
                Files.delete(storageOld.toPath());
            }
            catch (IOException e) {
                AnnoyingPlugin.log(Level.SEVERE, "&cFailed to delete previous &4storage-old.yml!");
            }
        }
        if ((storage = this.storageConfig.file.file).renameTo(storageOld)) {
            if (!storageNew.renameTo(storage)) {
                AnnoyingPlugin.log(Level.SEVERE, "&cFailed to rename &4storage-new.yml&c to &4storage.yml&c! You MUST rename &4storage-new.yml&c to &4storage.yml&c manually!");
            }
        } else {
            AnnoyingPlugin.log(Level.SEVERE, "&cFailed to rename &4storage.yml&c to &4storage-old.yml&c! You MUST rename &4storage.yml&c to &4storage-old.yml&c and &4storage-new.yml&c to &4storage.yml&c manually!");
        }
        AnnoyingPlugin.log(Level.WARNING, "&aSuccessfully finished migrating data from &2" + (Object)((Object)this.storageConfig.method) + "&a to &2" + (Object)((Object)storageNewConfig.method) + "&a!");
        return newManager;
    }
}

