/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit;

import com.srnyx.commandlogger.libs.annoyingapi.reflection.org.bukkit.RefNamespacedKey;
import com.srnyx.commandlogger.libs.annoyingapi.utility.ReflectionUtility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefRegistry {
    @Nullable
    public static final Class<?> REGISTRY_CLASS = ReflectionUtility.getClass(1, 14, 0, RefRegistry.class);
    @Nullable
    public static final Method GET_METHOD = ReflectionUtility.getMethod(1, 14, 0, REGISTRY_CLASS, "get", RefNamespacedKey.NAMESPACED_KEY_CLASS);
    @Nullable
    public static final Object EFFECT_FIELD = ReflectionUtility.getStaticFieldValue(1, 20, 3, REGISTRY_CLASS, "EFFECT");
    @Nullable
    public static final Object ENCHANTMENT_FIELD = ReflectionUtility.getStaticFieldValue(1, 14, 0, REGISTRY_CLASS, "ENCHANTMENT");

    @NotNull
    public static Optional<PotionEffectType> getEffect(@NotNull String name) {
        if (GET_METHOD != null && EFFECT_FIELD != null && RefNamespacedKey.MINECRAFT_METHOD != null) {
            try {
                return Optional.ofNullable((PotionEffectType)GET_METHOD.invoke(EFFECT_FIELD, RefNamespacedKey.MINECRAFT_METHOD.invoke(null, name)));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Optional.ofNullable(PotionEffectType.getByName((String)name));
    }

    @NotNull
    public static Optional<Enchantment> getEnchantment(@NotNull String name) {
        if (GET_METHOD != null && ENCHANTMENT_FIELD != null && RefNamespacedKey.MINECRAFT_METHOD != null) {
            try {
                return Optional.ofNullable((Enchantment)GET_METHOD.invoke(ENCHANTMENT_FIELD, RefNamespacedKey.MINECRAFT_METHOD.invoke(null, name)));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Optional.ofNullable(Enchantment.getByName((String)name));
    }

    private RefRegistry() {
        throw new UnsupportedOperationException("This is a reflected class and cannot be instantiated");
    }
}

