/*
 * Decompiled with CFR 0.152.
 */
package com.srnyx.commandlogger.libs.annoyingapi.options;

import com.srnyx.commandlogger.libs.annoyingapi.libs.javautilities.parents.Stringable;
import com.srnyx.commandlogger.libs.annoyingapi.options.BStatsOptions;
import com.srnyx.commandlogger.libs.annoyingapi.options.DataOptions;
import com.srnyx.commandlogger.libs.annoyingapi.options.MessagesOptions;
import com.srnyx.commandlogger.libs.annoyingapi.options.PluginOptions;
import com.srnyx.commandlogger.libs.annoyingapi.options.RegistrationOptions;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Consumer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnoyingOptions
extends Stringable {
    @NotNull
    public PluginOptions pluginOptions = new PluginOptions();
    @NotNull
    public RegistrationOptions registrationOptions = new RegistrationOptions();
    @NotNull
    public BStatsOptions bStatsOptions = new BStatsOptions();
    @NotNull
    public DataOptions dataOptions = new DataOptions();
    @NotNull
    public MessagesOptions messagesOptions = new MessagesOptions();

    @NotNull
    public static AnnoyingOptions load(@NotNull ConfigurationSection section) {
        ConfigurationSection messagesOptionsSection;
        ConfigurationSection dataOptionsSection;
        ConfigurationSection bStatsOptionsSection;
        ConfigurationSection registrationOptionsSection;
        AnnoyingOptions options = new AnnoyingOptions();
        ConfigurationSection pluginOptionsSection = section.getConfigurationSection("pluginOptions");
        if (pluginOptionsSection != null) {
            options.pluginOptions(PluginOptions.load(pluginOptionsSection));
        }
        if ((registrationOptionsSection = section.getConfigurationSection("registrationOptions")) != null) {
            options.registrationOptions(RegistrationOptions.load(registrationOptionsSection));
        }
        if ((bStatsOptionsSection = section.getConfigurationSection("bStatsOptions")) != null) {
            options.bStatsOptions(BStatsOptions.load(bStatsOptionsSection));
        }
        if ((dataOptionsSection = section.getConfigurationSection("dataOptions")) != null) {
            options.dataOptions(DataOptions.load(dataOptionsSection));
        }
        if ((messagesOptionsSection = section.getConfigurationSection("messagesOptions")) != null) {
            options.messagesOptions(MessagesOptions.load(messagesOptionsSection));
        }
        return options;
    }

    @NotNull
    public static AnnoyingOptions load(@Nullable InputStream inputStream) {
        if (inputStream == null) {
            return new AnnoyingOptions();
        }
        ConfigurationSection annoying = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream)).getConfigurationSection("annoying");
        if (annoying == null) {
            return new AnnoyingOptions();
        }
        return AnnoyingOptions.load(annoying);
    }

    @NotNull
    public AnnoyingOptions pluginOptions(@NotNull PluginOptions pluginOptions) {
        this.pluginOptions = pluginOptions;
        return this;
    }

    @NotNull
    public AnnoyingOptions pluginOptions(@NotNull Consumer<PluginOptions> consumer) {
        consumer.accept(this.pluginOptions);
        return this;
    }

    @NotNull
    public AnnoyingOptions bStatsOptions(@NotNull BStatsOptions bStatsOptions) {
        this.bStatsOptions = bStatsOptions;
        return this;
    }

    @NotNull
    public AnnoyingOptions bStatsOptions(@NotNull Consumer<BStatsOptions> consumer) {
        consumer.accept(this.bStatsOptions);
        return this;
    }

    @NotNull
    public AnnoyingOptions dataOptions(@NotNull DataOptions dataOptions) {
        this.dataOptions = dataOptions;
        return this;
    }

    @NotNull
    public AnnoyingOptions dataOptions(@NotNull Consumer<DataOptions> consumer) {
        consumer.accept(this.dataOptions);
        return this;
    }

    @NotNull
    public AnnoyingOptions messagesOptions(@NotNull MessagesOptions messagesOptions) {
        this.messagesOptions = messagesOptions;
        return this;
    }

    @NotNull
    public AnnoyingOptions messagesOptions(@NotNull Consumer<MessagesOptions> consumer) {
        consumer.accept(this.messagesOptions);
        return this;
    }

    @NotNull
    public AnnoyingOptions registrationOptions(@NotNull RegistrationOptions registrationOptions) {
        this.registrationOptions = registrationOptions;
        return this;
    }

    @NotNull
    public AnnoyingOptions registrationOptions(@NotNull Consumer<RegistrationOptions> consumer) {
        consumer.accept(this.registrationOptions);
        return this;
    }
}

